/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.avro.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.ArrayBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ValueWrapperFieldBridge
implements TwoWayFieldBridge {
    private static final Log log = (Log)LogFactory.getLog(ValueWrapperFieldBridge.class, Log.class);

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (name.contains(".")) {
            throw new CacheException("Name cannot contains delimiter \".\"");
        }
        GenericData.Record record = (GenericData.Record)value;
        Schema schema = record.getSchema();
        this.add(document, schema.getType(), "", value, schema);
    }

    public Object get(String name, Document document) {
        if (document.get(name).equals(Schema.Type.NULL.toString())) {
            return null;
        }
        return document.get(name);
    }

    public String objectToString(Object object) {
        if (object == null) {
            return Schema.Type.NULL.toString();
        }
        return object.toString();
    }

    private void add(Document document, Schema.Type type, String name, Object value, Schema schema) {
        if (value == null) {
            log.trace((Object)"ignoring null value");
            return;
        }
        switch (type) {
            case BYTES: 
            case NULL: {
                log.trace((Object)("type " + type + " not indexed"));
                break;
            }
            case INT: {
                this.add(document, (Field)new IntField(name, ((Integer)value).intValue(), Field.Store.NO));
                break;
            }
            case LONG: {
                this.add(document, (Field)new LongField(name, ((Long)value).longValue(), Field.Store.NO));
                break;
            }
            case FLOAT: {
                this.add(document, (Field)new FloatField(name, ((Float)value).floatValue(), Field.Store.NO));
                break;
            }
            case DOUBLE: {
                this.add(document, (Field)new DoubleField(name, ((Double)value).doubleValue(), Field.Store.NO));
                break;
            }
            case UNION: {
                for (Schema subSchema : schema.getTypes()) {
                    try {
                        this.add(document, subSchema.getType(), name, value, subSchema);
                    }
                    catch (Exception exception) {}
                }
                break;
            }
            case RECORD: {
                GenericData.Record record = (GenericData.Record)value;
                for (Schema.Field field : record.getSchema().getFields()) {
                    String fieldName = field.name();
                    Schema subSchema = field.schema();
                    this.add(document, subSchema.getType(), name.isEmpty() ? fieldName : name + "." + fieldName, record.get(fieldName), subSchema);
                }
                break;
            }
            case MAP: {
                Map map = (Map)value;
                for (Object k : map.keySet()) {
                    Schema subSchema = schema.getValueType();
                    if (map.get(k) == null) continue;
                    this.add(document, (Field)new StringField(name, k + "." + map.get(k).toString(), Field.Store.NO));
                }
                break;
            }
            case ARRAY: {
                GenericData.Array array = (GenericData.Array)value;
                for (int i = 0; i < array.size(); ++i) {
                    Schema subSchema = schema.getElementType();
                    this.add(document, subSchema.getType(), name + "." + i, array.get(i), subSchema);
                }
                break;
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BOOLEAN: {
                this.add(document, (Field)new StringField(name, value.toString(), Field.Store.NO));
                break;
            }
            default: {
                throw new CacheException("Unreachable code");
            }
        }
    }

    private void add(Document document, Field field) {
        if (field.stringValue().length() > 1000) {
            log.trace((Object)("field " + field.name() + " too long; not indexed"));
        } else {
            document.add((IndexableField)field);
            log.trace((Object)("adding " + field.name() + "[" + field.getClass().getSimpleName() + "]: " + field));
        }
    }

    public static FieldBridge retrieveFieldBridge(String fieldName, Schema schema) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(schema.getName());
        for (String p : fieldName.split("\\.")) {
            path.add(p);
        }
        return ValueWrapperFieldBridge.retrieveFieldBridge(schema.getType(), schema, path.toArray(new String[0]));
    }

    public static TwoWayFieldBridge retrieveFieldBridge(Schema.Type type, Schema schema, String[] path) {
        switch (type) {
            case BYTES: 
            case NULL: {
                log.trace((Object)("type " + type + " not indexed"));
            }
            case INT: {
                return NumericFieldBridge.INT_FIELD_BRIDGE;
            }
            case LONG: {
                return NumericFieldBridge.LONG_FIELD_BRIDGE;
            }
            case FLOAT: {
                return NumericFieldBridge.FLOAT_FIELD_BRIDGE;
            }
            case DOUBLE: {
                return NumericFieldBridge.DOUBLE_FIELD_BRIDGE;
            }
            case UNION: {
                for (Schema subSchema : schema.getTypes()) {
                    if (subSchema.getType().equals((Object)Schema.Type.NULL)) continue;
                    return ValueWrapperFieldBridge.retrieveFieldBridge(subSchema.getType(), subSchema, path);
                }
                break;
            }
            case RECORD: {
                String[] subPath = Arrays.copyOfRange(path, 1, path.length);
                for (Schema.Field field : schema.getFields()) {
                    if (!field.name().equals(path[1])) continue;
                    return ValueWrapperFieldBridge.retrieveFieldBridge(field.schema().getType(), field.schema(), subPath);
                }
                break;
            }
            case MAP: {
                Schema subSchema = schema.getValueType();
                return ValueWrapperFieldBridge.retrieveFieldBridge(subSchema.getType(), subSchema, Arrays.copyOfRange(path, 1, path.length));
            }
            case ARRAY: {
                Schema subSchema = schema.getElementType();
                return new TwoWayArrayBridge(ValueWrapperFieldBridge.retrieveFieldBridge(subSchema.getType(), subSchema, path));
            }
            case ENUM: 
            case FIXED: 
            case STRING: 
            case BOOLEAN: {
                return new TwoWayString2FieldBridgeAdaptor((TwoWayStringBridge)StringBridge.INSTANCE);
            }
        }
        throw new CacheException("Unable to find " + Arrays.toString(path) + " having type " + type);
    }

    public static class TwoWayArrayBridge
    extends ArrayBridge
    implements TwoWayFieldBridge {
        private TwoWayFieldBridge bridge;

        public TwoWayArrayBridge(TwoWayFieldBridge bridge) {
            super((FieldBridge)bridge);
            this.bridge = bridge;
        }

        public Object get(String name, Document document) {
            Object o;
            ArrayList<Object> array = new ArrayList<Object>();
            int i = 0;
            while ((o = this.bridge.get(name + "." + i, document)) != null) {
                array.add(o);
                ++i;
            }
            return document.getFields(name);
        }

        public String objectToString(Object object) {
            throw new CacheException("NYI.");
        }
    }
}

