/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.configuration;

import org.infinispan.commons.configuration.io.ConfigurationReader;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.persistence.jpa.configuration.Attribute;
import org.infinispan.persistence.jpa.configuration.Element;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;

@Namespaces(value={@Namespace(root="jpa-store"), @Namespace(uri="urn:infinispan:config:store:jpa:*", root="jpa-store")})
public class JpaStoreConfigurationParser
implements ConfigurationParser {
    static final String NAMESPACE = "urn:infinispan:config:store:jpa:";

    public void readElement(ConfigurationReader reader, ConfigurationBuilderHolder holder) {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case JPA_STORE: {
                ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
                this.parseJpaCacheStore(reader, (JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class), holder.getClassLoader());
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((ConfigurationReader)reader);
            }
        }
    }

    private void parseJpaCacheStore(ConfigurationReader reader, JpaStoreConfigurationBuilder builder, ClassLoader classLoader) {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((ConfigurationReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeName(i));
            switch (attribute) {
                case ENTITY_CLASS_NAME: {
                    Class clazz = Util.loadClass((String)value, (ClassLoader)classLoader);
                    builder.entityClass(clazz);
                    continue block6;
                }
                case BATCH_SIZE: {
                    builder.batchSize(Long.valueOf(value));
                    continue block6;
                }
                case PERSISTENCE_UNIT_NAME: {
                    builder.persistenceUnitName(value);
                    continue block6;
                }
                case STORE_METADATA: {
                    builder.storeMetadata(Boolean.valueOf(value));
                    continue block6;
                }
                default: {
                    Parser.parseStoreAttribute((ConfigurationReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        while (reader.inTag()) {
            Parser.parseStoreElement((ConfigurationReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }
}

