/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledEntryImpl;
import org.infinispan.persistence.jpa.AbstractJpaStoreTest;
import org.infinispan.persistence.jpa.TestObject;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.BaseJpaStoreTest")
public abstract class BaseJpaStoreTest
extends AbstractJpaStoreTest {
    protected abstract TestObject createTestObject(String var1);

    @Test(expectedExceptions={PersistenceException.class})
    public void testStoreNoJpa() {
        Assert.assertFalse((boolean)this.cs.contains((Object)"k"));
        this.cs.write((MarshalledEntry)this.createEntry("k", "v"));
    }

    @Test(expectedExceptions={PersistenceException.class})
    public void testStoreWithJpaBadKey() {
        Assert.assertFalse((boolean)this.cs.contains((Object)"k"));
        TestObject obj = this.createTestObject("1");
        this.cs.write((MarshalledEntry)this.createEntry("k", obj.getValue()));
    }

    public void testStoreWithJpaGoodKey() {
        TestObject obj = this.createTestObject("testStoreWithJpaGoodKey");
        Assert.assertFalse((boolean)this.cs.contains(obj.getKey()));
        MarshalledEntryImpl me = this.createEntry(obj);
        this.cs.write((MarshalledEntry)me);
    }

    public void testLoadAndStoreImmortal() {
        TestObject obj = this.createTestObject("testLoadAndStoreImmortal");
        Assert.assertFalse((boolean)this.cs.contains(obj.getKey()));
        MarshalledEntryImpl me = this.createEntry(obj);
        this.cs.write((MarshalledEntry)me);
        Assert.assertTrue((boolean)this.cs.contains(obj.getKey()));
        Assert.assertEquals((Object)obj.getValue(), (Object)this.cs.load(obj.getKey()).getValue());
        Assert.assertNull((Object)this.cs.load(obj.getKey()).getMetadata());
        boolean removed = this.cs.delete((Object)"nonExistentKey");
        Assert.assertFalse((boolean)removed);
    }

    public void testPreload() throws Exception {
        TestObject obj1 = this.createTestObject("testPreload1");
        TestObject obj2 = this.createTestObject("testPreload2");
        TestObject obj3 = this.createTestObject("testPreload3");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        this.cs.write((MarshalledEntry)this.createEntry(obj3));
        Assert.assertEquals((Object)this.cs.load(obj1.getKey()).getValue(), (Object)obj1.getValue());
        Assert.assertEquals((Object)this.cs.load(obj2.getKey()).getValue(), (Object)obj2.getValue());
        Assert.assertEquals((Object)this.cs.load(obj3.getKey()).getValue(), (Object)obj3.getValue());
        final ConcurrentHashMap map = new ConcurrentHashMap();
        AdvancedCacheLoader.CacheLoaderTask taskWithValues = new AdvancedCacheLoader.CacheLoaderTask(){

            public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                if (marshalledEntry.getKey() != null && marshalledEntry.getValue() != null) {
                    map.put(marshalledEntry.getKey(), marshalledEntry.getValue());
                }
            }
        };
        this.cs.process(null, taskWithValues, (Executor)new ThreadPoolExecutor(1, 2, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10)), true, false);
        Assert.assertEquals((int)map.size(), (int)3);
        Assert.assertEquals(map.remove(obj1.getKey()), (Object)obj1.getValue());
        Assert.assertEquals(map.remove(obj2.getKey()), (Object)obj2.getValue());
        Assert.assertEquals(map.remove(obj3.getKey()), (Object)obj3.getValue());
        Assert.assertTrue((boolean)map.isEmpty());
        final ConcurrentHashSet set = new ConcurrentHashSet();
        AdvancedCacheLoader.CacheLoaderTask taskWithoutValues = new AdvancedCacheLoader.CacheLoaderTask(){

            public void processEntry(MarshalledEntry marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
                if (marshalledEntry.getKey() != null) {
                    set.add(marshalledEntry.getKey());
                }
            }
        };
        this.cs.process(null, taskWithoutValues, (Executor)new ThreadPoolExecutor(1, 2, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10)), false, false);
        Assert.assertEquals((int)set.size(), (int)3);
        Assert.assertTrue((boolean)set.remove(obj1.getKey()));
        Assert.assertTrue((boolean)set.remove(obj2.getKey()));
        Assert.assertTrue((boolean)set.remove(obj3.getKey()));
        Assert.assertTrue((boolean)map.isEmpty());
    }

    public void testStoreAndRemoveAll() {
        TestObject obj1 = this.createTestObject("testStoreAndRemoveAll1");
        TestObject obj2 = this.createTestObject("testStoreAndRemoveAll2");
        TestObject obj3 = this.createTestObject("testStoreAndRemoveAll3");
        TestObject obj4 = this.createTestObject("testStoreAndRemoveAll4");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        this.cs.write((MarshalledEntry)this.createEntry(obj3));
        this.cs.write((MarshalledEntry)this.createEntry(obj4));
        Assert.assertEquals((int)this.cs.size(), (int)4);
        this.cs.clear();
        Assert.assertEquals((int)this.cs.size(), (int)0);
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj2.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj3.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj4.getKey()));
    }

    public void testStoreValuesViaNonJpaCacheStore() {
        TestObject obj1 = this.createTestObject("testStoreViaNonJpaCacheStore1");
        TestObject obj2 = this.createTestObject("testStoreViaNonJpaCacheStore2");
        Assert.assertEquals((int)this.cs.size(), (int)0);
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertFalse((boolean)this.cs.contains(obj1.getKey()));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.infinispan.persistence.jpa");
        EntityManager em = emf.createEntityManager();
        EntityTransaction txn = em.getTransaction();
        txn.begin();
        em.persist(obj1.getValue());
        em.persist(obj2.getValue());
        em.flush();
        txn.commit();
        em.close();
        Assert.assertEquals((int)this.cs.size(), (int)2);
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
    }

    public void testLoadValuesViaNonJpaCacheStore() {
        TestObject obj1 = this.createTestObject("testLoadViaNonJpaCacheStore1");
        TestObject obj2 = this.createTestObject("testLoadViaNonJpaCacheStore2");
        this.cs.write((MarshalledEntry)this.createEntry(obj1));
        this.cs.write((MarshalledEntry)this.createEntry(obj2));
        Assert.assertEquals((int)this.cs.size(), (int)2);
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        Assert.assertTrue((boolean)this.cs.contains(obj1.getKey()));
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.infinispan.persistence.jpa");
        EntityManager em = emf.createEntityManager();
        Assert.assertEquals((Object)em.find(obj1.getValue().getClass(), obj1.getKey()), (Object)obj1.getValue());
        Assert.assertEquals((Object)em.find(obj2.getValue().getClass(), obj2.getKey()), (Object)obj2.getValue());
        em.close();
    }
}

