/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Version;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.persistence.jpa.impl.MetadataEntityKey;

@Entity
@Table(name="`__ispn_metadata__`")
public class MetadataEntity {
    public static final String EXPIRATION = "expiration";
    @EmbeddedId
    private MetadataEntityKey key;
    @Lob
    @Column(length=65535)
    private byte[] keyBytes;
    @Lob
    @Column(length=65535)
    private byte[] metadata;
    @Column(name="expiration")
    private long expiration;
    @Version
    private int version;

    public MetadataEntity() {
    }

    public MetadataEntity(ByteBuffer key, ByteBuffer metadata, long expiration) {
        this.keyBytes = this.trimmedBytes(key);
        this.key = new MetadataEntityKey(this.keyBytes);
        if (metadata != null) {
            this.metadata = this.trimmedBytes(metadata);
        }
        this.expiration = expiration < 0L ? Long.MAX_VALUE : expiration;
    }

    private byte[] trimmedBytes(ByteBuffer buf) {
        if (buf.getOffset() == 0 && buf.getLength() == buf.getBuf().length) {
            return buf.getBuf();
        }
        byte[] bytes = new byte[buf.getLength()];
        System.arraycopy(buf.getBuf(), buf.getOffset(), bytes, 0, buf.getLength());
        return bytes;
    }

    public MetadataEntityKey getKey() {
        return this.key;
    }

    public void setKey(MetadataEntityKey key) {
        this.key = key;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata(byte[] metadata) {
        this.metadata = metadata;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean hasBytes() {
        return this.metadata != null;
    }
}

