/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa;

import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.persistence.jpa.JpaStoreTest;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="persistence.JpaStoreNoMetadataTest")
public class JpaStoreNoMetadataTest
extends JpaStoreTest {
    @Override
    protected boolean storeMetadata() {
        return false;
    }

    @Override
    protected String getPersistenceUnitName() {
        return "org.infinispan.persistence.jpa.no_metadata";
    }

    @Test(enabled=false, description="Not applicable")
    public void testLoadAndStoreWithLifespan() throws Exception {
    }

    @Test(enabled=false, description="Not applicable")
    public void testLoadAndStoreWithIdle() throws Exception {
    }

    @Test(enabled=false, description="Not applicable")
    public void testLoadAndStoreWithLifespanAndIdle() throws Exception {
    }

    @Test(enabled=false, description="Not applicable")
    public void testLoadAndStoreWithLifespanAndIdle2() throws Exception {
    }

    @Test(enabled=false, description="Not applicable")
    public void testReplaceExpiredEntry() throws Exception {
    }

    public void testPurgeExpired() throws Exception {
        long lifespan = 6000L;
        long idle = 4000L;
        InternalCacheEntry ice1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)this.wrap("k1", "v1"), (long)lifespan);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice1, (StreamingMarshaller)this.getMarshaller()));
        InternalCacheEntry ice2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)this.wrap("k2", "v2"), (long)-1L, (long)idle);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice2, (StreamingMarshaller)this.getMarshaller()));
        InternalCacheEntry ice3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)this.wrap("k3", "v3"), (long)lifespan, (long)idle);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice3, (StreamingMarshaller)this.getMarshaller()));
        InternalCacheEntry ice4 = TestInternalCacheEntryFactory.create((Object)"k4", (Object)this.wrap("k4", "v4"), (long)-1L, (long)-1L);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice4, (StreamingMarshaller)this.getMarshaller()));
        InternalCacheEntry ice5 = TestInternalCacheEntryFactory.create((Object)"k5", (Object)this.wrap("k5", "v5"), (long)(lifespan * 1000L), (long)(idle * 1000L));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)ice5, (StreamingMarshaller)this.getMarshaller()));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k1"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k2"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k3"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k4"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k5"));
        this.purgeExpired(new String[0]);
        Assert.assertTrue((boolean)this.cl.contains((Object)"k1"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k2"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k3"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k4"));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k5"));
    }

    public void testStopStartDoesNotNukeValues() throws InterruptedException, PersistenceException {
        AssertJUnit.assertFalse((boolean)this.cl.contains((Object)"k1"));
        AssertJUnit.assertFalse((boolean)this.cl.contains((Object)"k2"));
        long lifespan = 1L;
        long idle = 1L;
        InternalCacheEntry se1 = TestInternalCacheEntryFactory.create((Object)"k1", (Object)this.wrap("k1", "v1"), (long)lifespan);
        InternalCacheEntry se2 = TestInternalCacheEntryFactory.create((Object)"k2", (Object)this.wrap("k2", "v2"));
        InternalCacheEntry se3 = TestInternalCacheEntryFactory.create((Object)"k3", (Object)this.wrap("k3", "v3"), (long)-1L, (long)idle);
        InternalCacheEntry se4 = TestInternalCacheEntryFactory.create((Object)"k4", (Object)this.wrap("k4", "v4"), (long)lifespan, (long)idle);
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se1, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se2, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se3, (StreamingMarshaller)this.getMarshaller()));
        this.cl.write(TestingUtil.marshalledEntry((InternalCacheEntry)se4, (StreamingMarshaller)this.getMarshaller()));
        this.timeService.advance(lifespan + 1L);
        this.cl.stop();
        this.cl.start();
        Assert.assertTrue((boolean)se1.isExpired(System.currentTimeMillis()));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k1"));
        AssertJUnit.assertEquals((String)"v1", (String)this.unwrap(this.cl.load((Object)"k1").getValue()));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k2"));
        AssertJUnit.assertEquals((String)"v2", (String)this.unwrap(this.cl.load((Object)"k2").getValue()));
        Assert.assertTrue((boolean)se3.isExpired(System.currentTimeMillis()));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k3"));
        AssertJUnit.assertEquals((String)"v3", (String)this.unwrap(this.cl.load((Object)"k3").getValue()));
        Assert.assertTrue((boolean)se3.isExpired(System.currentTimeMillis()));
        Assert.assertTrue((boolean)this.cl.contains((Object)"k4"));
        AssertJUnit.assertEquals((String)"v4", (String)this.unwrap(this.cl.load((Object)"k4").getValue()));
    }
}

