/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.persistence.rocksdb.RocksDBStore;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationSerializer;

@ConfigurationFor(value=RocksDBStore.class)
@BuiltBy(value=RocksDBStoreConfigurationBuilder.class)
@SerializedWith(value=RocksDBStoreConfigurationSerializer.class)
public class RocksDBStoreConfiguration
extends AbstractStoreConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", (Object)"Infinispan-RocksDBStore/data").immutable().xmlName("path").build();
    static final AttributeDefinition<CompressionType> COMPRESSION_TYPE = AttributeDefinition.builder((String)"compressionType", (Object)((Object)CompressionType.NONE)).immutable().autoPersist(false).build();
    static final AttributeDefinition<Integer> BLOCK_SIZE = AttributeDefinition.builder((String)"blockSize", (Object)0).immutable().build();
    static final AttributeDefinition<Long> CACHE_SIZE = AttributeDefinition.builder((String)"cacheSize", (Object)0L).immutable().build();
    static final AttributeDefinition<Integer> CLEAR_THRESHOLD = AttributeDefinition.builder((String)"clearThreshold", (Object)10000).immutable().build();
    public static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.ROCKSDB_STORE.getLocalName());
    private final Attribute<String> location;
    private final Attribute<CompressionType> compressionType;
    private final Attribute<Integer> blockSize;
    private final Attribute<Long> cacheSize;
    private final Attribute<Integer> clearThreshold;
    private final RocksDBExpirationConfiguration expiration;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(RocksDBStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, COMPRESSION_TYPE, BLOCK_SIZE, CACHE_SIZE, CLEAR_THRESHOLD});
    }

    public RocksDBStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, RocksDBExpirationConfiguration expiration) {
        super(attributes, async);
        this.location = attributes.attribute(LOCATION);
        this.compressionType = attributes.attribute(COMPRESSION_TYPE);
        this.blockSize = attributes.attribute(BLOCK_SIZE);
        this.cacheSize = attributes.attribute(CACHE_SIZE);
        this.clearThreshold = attributes.attribute(CLEAR_THRESHOLD);
        this.expiration = expiration;
    }

    public RocksDBExpirationConfiguration expiration() {
        return this.expiration;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return Collections.singletonList(this.expiration);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String location() {
        return (String)this.location.get();
    }

    public String expiredLocation() {
        return this.expiration.expiredLocation();
    }

    public CompressionType compressionType() {
        return (CompressionType)((Object)this.compressionType.get());
    }

    public Integer blockSize() {
        return (Integer)this.blockSize.get();
    }

    public Long cacheSize() {
        return (Long)this.cacheSize.get();
    }

    public int expiryQueueSize() {
        return this.expiration.expiryQueueSize();
    }

    public int clearThreshold() {
        return (Integer)this.clearThreshold.get();
    }
}

