/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import java.util.Collection;
import java.util.Collections;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.persistence.rocksdb.configuration.CompressionType;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;

public class RocksDBStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<RocksDBStoreConfiguration, RocksDBStoreConfigurationBuilder>
implements ConfigurationBuilderInfo {
    protected RocksDBExpirationConfigurationBuilder expiration = new RocksDBExpirationConfigurationBuilder();

    public RocksDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, RocksDBStoreConfiguration.attributeDefinitionSet());
    }

    public RocksDBStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet) {
        super(builder, attributeSet);
    }

    public ElementDefinition getElementDefinition() {
        return RocksDBStoreConfiguration.ELEMENT_DEFINITION;
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return Collections.singletonList(this.expiration);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RocksDBStoreConfigurationBuilder location(String location) {
        this.attributes.attribute(RocksDBStoreConfiguration.LOCATION).set((Object)location);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder expiredLocation(String expiredLocation) {
        this.expiration.expiredLocation(expiredLocation);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder blockSize(int blockSize) {
        this.attributes.attribute(RocksDBStoreConfiguration.BLOCK_SIZE).set((Object)blockSize);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder cacheSize(long cacheSize) {
        this.attributes.attribute(RocksDBStoreConfiguration.CACHE_SIZE).set((Object)cacheSize);
        return this.self();
    }

    @Deprecated
    public RocksDBStoreConfigurationBuilder expiryQueueSize(int expiryQueueSize) {
        this.expiration.expiryQueueSize(expiryQueueSize);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder clearThreshold(int clearThreshold) {
        this.attributes.attribute(RocksDBStoreConfiguration.CLEAR_THRESHOLD).set((Object)clearThreshold);
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder compressionType(CompressionType compressionType) {
        this.attributes.attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).set((Object)compressionType);
        return this.self();
    }

    public void validate() {
        super.validate();
        this.expiration.validate();
    }

    public RocksDBStoreConfiguration create() {
        return new RocksDBStoreConfiguration(this.attributes.protect(), this.async.create(), this.expiration.create());
    }

    public Builder<?> read(RocksDBStoreConfiguration template) {
        super.read((StoreConfiguration)template);
        this.expiration.read(template.expiration());
        return this.self();
    }

    public RocksDBStoreConfigurationBuilder self() {
        return this;
    }
}

