/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rocksdb.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.persistence.rocksdb.configuration.Attribute;
import org.infinispan.persistence.rocksdb.configuration.Element;
import org.infinispan.persistence.rocksdb.configuration.RocksDBExpirationConfiguration;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfiguration;

public class RocksDBStoreConfigurationSerializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<RocksDBStoreConfiguration> {
    public void serialize(XMLExtendedStreamWriter writer, RocksDBStoreConfiguration configuration) throws XMLStreamException {
        RocksDBExpirationConfiguration expiration;
        AttributeSet expirationAttrs;
        AttributeSet attributes = configuration.attributes();
        writer.writeStartElement((Enum)Element.ROCKSDB_STORE);
        writer.writeDefaultNamespace("urn:infinispan:config:store:rocksdb:" + Version.getMajorMinor());
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        if (attributes.attribute(RocksDBStoreConfiguration.COMPRESSION_TYPE).isModified()) {
            writer.writeStartElement((Enum)Element.COMPRESSION);
            attributes.write((XMLStreamWriter)writer, RocksDBStoreConfiguration.COMPRESSION_TYPE, (Enum)Attribute.TYPE);
            writer.writeEndElement();
        }
        if ((expirationAttrs = (expiration = configuration.expiration()).attributes()).attribute(RocksDBExpirationConfiguration.EXPIRED_LOCATION).isModified() || expirationAttrs.attribute(RocksDBExpirationConfiguration.EXPIRY_QUEUE_SIZE).isModified()) {
            writer.writeStartElement((Enum)Element.EXPIRATION);
            expirationAttrs.write((XMLStreamWriter)writer, RocksDBExpirationConfiguration.EXPIRED_LOCATION, (Enum)Attribute.PATH);
            expirationAttrs.write((XMLStreamWriter)writer, RocksDBExpirationConfiguration.EXPIRY_QUEUE_SIZE, (Enum)Attribute.QUEUE_SIZE);
            writer.writeEndElement();
        }
        this.writeCommonStoreElements(writer, (StoreConfiguration)configuration);
        writer.writeEndElement();
    }
}

