/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util.annotatedtypebuilder;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.infinispan.cdi.common.util.Reflections;
import org.infinispan.cdi.common.util.annotatedtypebuilder.AnnotatedTypeImpl;
import org.infinispan.cdi.common.util.annotatedtypebuilder.AnnotationBuilder;
import org.infinispan.cdi.common.util.annotatedtypebuilder.AnnotationStore;
import org.infinispan.cdi.common.util.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class AnnotatedTypeBuilder<X> {
    private static final Log log = (Log)LogFactory.getLog(AnnotatedTypeBuilder.class, Log.class);
    private Class<X> javaClass;
    private final AnnotationBuilder typeAnnotations = new AnnotationBuilder();
    private final Map<Constructor<?>, AnnotationBuilder> constructors = new HashMap();
    private final Map<Constructor<?>, Map<Integer, AnnotationBuilder>> constructorParameters = new HashMap();
    private final Map<Constructor<?>, Map<Integer, Type>> constructorParameterTypes = new HashMap();
    private final Map<Field, AnnotationBuilder> fields = new HashMap<Field, AnnotationBuilder>();
    private final Map<Field, Type> fieldTypes = new HashMap<Field, Type>();
    private final Map<Method, AnnotationBuilder> methods = new HashMap<Method, AnnotationBuilder>();
    private final Map<Method, Map<Integer, AnnotationBuilder>> methodParameters = new HashMap<Method, Map<Integer, AnnotationBuilder>>();
    private final Map<Method, Map<Integer, Type>> methodParameterTypes = new HashMap<Method, Map<Integer, Type>>();

    public AnnotatedTypeBuilder<X> addToClass(Annotation annotation) {
        this.typeAnnotations.add(annotation);
        return this;
    }

    public AnnotatedTypeBuilder<X> readFromType(AnnotatedType<X> type) {
        return this.readFromType(type, true);
    }

    public AnnotatedTypeBuilder<X> readFromType(AnnotatedType<X> type, boolean overwrite) {
        if (type == null) {
            throw log.parameterMustNotBeNull("type");
        }
        if (this.javaClass == null || overwrite) {
            this.javaClass = type.getJavaClass();
        }
        this.mergeAnnotationsOnElement((Annotated)type, overwrite, this.typeAnnotations);
        for (AnnotatedField field : type.getFields()) {
            if (this.fields.get(field.getJavaMember()) == null) {
                this.fields.put(field.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)field, overwrite, this.fields.get(field.getJavaMember()));
        }
        for (AnnotatedMethod method : type.getMethods()) {
            if (this.methods.get(method.getJavaMember()) == null) {
                this.methods.put(method.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)method, overwrite, this.methods.get(method.getJavaMember()));
            for (AnnotatedParameter p : method.getParameters()) {
                if (this.methodParameters.get(method.getJavaMember()) == null) {
                    this.methodParameters.put(method.getJavaMember(), new HashMap());
                }
                if (this.methodParameters.get(method.getJavaMember()).get(p.getPosition()) == null) {
                    this.methodParameters.get(method.getJavaMember()).put(p.getPosition(), new AnnotationBuilder());
                }
                this.mergeAnnotationsOnElement((Annotated)p, overwrite, this.methodParameters.get(method.getJavaMember()).get(p.getPosition()));
            }
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (this.constructors.get(constructor.getJavaMember()) == null) {
                this.constructors.put(constructor.getJavaMember(), new AnnotationBuilder());
            }
            this.mergeAnnotationsOnElement((Annotated)constructor, overwrite, this.constructors.get(constructor.getJavaMember()));
            for (AnnotatedParameter p : constructor.getParameters()) {
                if (this.constructorParameters.get(constructor.getJavaMember()) == null) {
                    this.constructorParameters.put(constructor.getJavaMember(), new HashMap());
                }
                if (this.constructorParameters.get(constructor.getJavaMember()).get(p.getPosition()) == null) {
                    this.constructorParameters.get(constructor.getJavaMember()).put(p.getPosition(), new AnnotationBuilder());
                }
                this.mergeAnnotationsOnElement((Annotated)p, overwrite, this.constructorParameters.get(constructor.getJavaMember()).get(p.getPosition()));
            }
        }
        return this;
    }

    public AnnotatedTypeBuilder<X> readFromType(Class<X> type) {
        return this.readFromType(type, true);
    }

    /*
     * WARNING - void declaration
     */
    public AnnotatedTypeBuilder<X> readFromType(Class<X> type, boolean overwrite) {
        if (type == null) {
            throw log.parameterMustNotBeNull("type");
        }
        if (this.javaClass == null || overwrite) {
            this.javaClass = type;
        }
        for (Annotation annotation : type.getAnnotations()) {
            if (!overwrite && this.typeAnnotations.isAnnotationPresent(annotation.annotationType())) continue;
            this.typeAnnotations.add(annotation);
        }
        for (Field field : Reflections.getAllDeclaredFields(type)) {
            AnnotationBuilder annotationBuilder = this.fields.get(field);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.fields.put(field, annotationBuilder);
            }
            field.setAccessible(true);
            for (Annotation annotation : field.getAnnotations()) {
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
        }
        for (Method method : Reflections.getAllDeclaredMethods(type)) {
            AnnotationBuilder annotationBuilder = this.methods.get(method);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.methods.put(method, annotationBuilder);
            }
            method.setAccessible(true);
            for (Annotation annotation : method.getAnnotations()) {
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
            Map<Integer, AnnotationBuilder> map = this.methodParameters.get(method);
            if (map == null) {
                HashMap hashMap = new HashMap();
                this.methodParameters.put(method, hashMap);
            }
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                void var6_17;
                AnnotationBuilder parameterAnnotationBuilder = (AnnotationBuilder)var6_17.get(i);
                if (parameterAnnotationBuilder == null) {
                    parameterAnnotationBuilder = new AnnotationBuilder();
                    var6_17.put(i, parameterAnnotationBuilder);
                }
                for (Annotation annotation2 : method.getParameterAnnotations()[i]) {
                    if (!overwrite && parameterAnnotationBuilder.isAnnotationPresent(annotation2.annotationType())) continue;
                    parameterAnnotationBuilder.add(annotation2);
                }
            }
        }
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            AnnotationBuilder annotationBuilder = this.constructors.get(constructor);
            if (annotationBuilder == null) {
                annotationBuilder = new AnnotationBuilder();
                this.constructors.put(constructor, annotationBuilder);
            }
            constructor.setAccessible(true);
            Annotation[] parameterAnnotationBuilder = constructor.getAnnotations();
            int n = parameterAnnotationBuilder.length;
            for (int i = 0; i < n; ++i) {
                Annotation annotation = parameterAnnotationBuilder[i];
                if (!overwrite && annotationBuilder.isAnnotationPresent(annotation.annotationType())) continue;
                annotationBuilder.add(annotation);
            }
            Map<Integer, AnnotationBuilder> mparams = this.constructorParameters.get(constructor);
            if (mparams == null) {
                mparams = new HashMap<Integer, AnnotationBuilder>();
                this.constructorParameters.put(constructor, mparams);
            }
            for (n = 0; n < constructor.getParameterTypes().length; ++n) {
                AnnotationBuilder parameterAnnotationBuilder2 = mparams.get(n);
                if (parameterAnnotationBuilder2 == null) {
                    parameterAnnotationBuilder2 = new AnnotationBuilder();
                    mparams.put(n, parameterAnnotationBuilder2);
                }
                for (Annotation annotation : constructor.getParameterAnnotations()[n]) {
                    if (!overwrite && parameterAnnotationBuilder2.isAnnotationPresent(annotation.annotationType())) continue;
                    annotationBuilder.add(annotation);
                }
            }
        }
        return this;
    }

    protected void mergeAnnotationsOnElement(Annotated annotated, boolean overwriteExisting, AnnotationBuilder typeAnnotations) {
        for (Annotation annotation : annotated.getAnnotations()) {
            if (typeAnnotations.getAnnotation(annotation.annotationType()) != null) {
                if (!overwriteExisting) continue;
                typeAnnotations.remove(annotation.annotationType());
                typeAnnotations.add(annotation);
                continue;
            }
            typeAnnotations.add(annotation);
        }
    }

    public AnnotatedType<X> create() {
        HashMap<Integer, AnnotationStore> parameterAnnotations;
        HashMap constructorParameterAnnnotations = new HashMap();
        HashMap constructorAnnotations = new HashMap();
        HashMap<Method, Map<Integer, AnnotationStore>> methodParameterAnnnotations = new HashMap<Method, Map<Integer, AnnotationStore>>();
        HashMap<Method, AnnotationStore> methodAnnotations = new HashMap<Method, AnnotationStore>();
        HashMap<Field, AnnotationStore> fieldAnnotations = new HashMap<Field, AnnotationStore>();
        for (Map.Entry<Field, AnnotationBuilder> entry : this.fields.entrySet()) {
            fieldAnnotations.put(entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, AnnotationBuilder> entry : this.methods.entrySet()) {
            methodAnnotations.put((Method)entry.getKey(), entry.getValue().create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.methodParameters.entrySet()) {
            parameterAnnotations = new HashMap<Integer, AnnotationStore>();
            methodParameterAnnnotations.put((Method)entry.getKey(), parameterAnnotations);
            for (Map.Entry parameter : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put((Integer)parameter.getKey(), ((AnnotationBuilder)parameter.getValue()).create());
            }
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructors.entrySet()) {
            constructorAnnotations.put((Constructor)entry.getKey(), ((AnnotationBuilder)entry.getValue()).create());
        }
        for (Map.Entry<AccessibleObject, Object> entry : this.constructorParameters.entrySet()) {
            parameterAnnotations = new HashMap();
            constructorParameterAnnnotations.put((Constructor)entry.getKey(), parameterAnnotations);
            for (Map.Entry parameter : ((Map)entry.getValue()).entrySet()) {
                parameterAnnotations.put((Integer)parameter.getKey(), ((AnnotationBuilder)parameter.getValue()).create());
            }
        }
        return new AnnotatedTypeImpl<X>(this.javaClass, this.typeAnnotations.create(), fieldAnnotations, methodAnnotations, methodParameterAnnnotations, constructorAnnotations, constructorParameterAnnnotations, this.fieldTypes, this.methodParameterTypes, this.constructorParameterTypes);
    }

    public AnnotatedTypeBuilder<X> removeFromClass(Class<? extends Annotation> annotationType) {
        this.typeAnnotations.remove(annotationType);
        return this;
    }

    public AnnotatedTypeBuilder<X> removeFromMethod(Method method, Class<? extends Annotation> annotationType) {
        if (this.methods.get(method) == null) {
            throw new IllegalArgumentException("Method not present " + method.toString() + " on " + this.javaClass);
        }
        this.methods.get(method).remove(annotationType);
        return this;
    }

    public AnnotatedTypeBuilder<X> removeFromMethod(AnnotatedMethod<? super X> method, Class<? extends Annotation> annotationType) {
        return this.removeFromMethod(method.getJavaMember(), annotationType);
    }

    public AnnotatedTypeBuilder<X> addToMethod(Method method, Annotation annotation) {
        if (this.methods.get(method) == null) {
            this.methods.put(method, new AnnotationBuilder());
        }
        this.methods.get(method).add(annotation);
        return this;
    }

    public AnnotatedTypeBuilder<X> addToMethod(AnnotatedMethod<? super X> method, Annotation annotation) {
        return this.addToMethod(method.getJavaMember(), annotation);
    }

    public AnnotatedTypeBuilder<X> addToMethodParameter(Method method, int position, Annotation annotation) {
        if (!this.methods.containsKey(method)) {
            this.methods.put(method, new AnnotationBuilder());
        }
        if (this.methodParameters.get(method) == null) {
            this.methodParameters.put(method, new HashMap());
        }
        if (this.methodParameters.get(method).get(position) == null) {
            this.methodParameters.get(method).put(position, new AnnotationBuilder());
        }
        this.methodParameters.get(method).get(position).add(annotation);
        return this;
    }

    public AnnotatedTypeBuilder<X> removeFromMethodParameter(Method method, int position, Class<? extends Annotation> annotationType) {
        if (this.methods.get(method) == null) {
            throw new IllegalArgumentException("Method not present " + method + " on " + this.javaClass);
        }
        if (this.methodParameters.get(method).get(position) == null) {
            throw new IllegalArgumentException("Method parameter " + position + " not present on " + method + " on " + this.javaClass);
        }
        this.methodParameters.get(method).get(position).remove(annotationType);
        return this;
    }

    public AnnotatedTypeBuilder<X> addToField(Field field, Annotation annotation) {
        if (this.fields.get(field) == null) {
            this.fields.put(field, new AnnotationBuilder());
        }
        this.fields.get(field).add(annotation);
        return this;
    }

    public AnnotatedTypeBuilder<X> addToField(AnnotatedField<? super X> field, Annotation annotation) {
        return this.addToField(field.getJavaMember(), annotation);
    }

    public AnnotatedTypeBuilder<X> removeFromField(Field field, Class<? extends Annotation> annotationType) {
        if (this.fields.get(field) == null) {
            throw new IllegalArgumentException("Field not present " + field + " on " + this.javaClass);
        }
        this.fields.get(field).remove(annotationType);
        return this;
    }

    public AnnotatedTypeBuilder<X> removeFromField(AnnotatedField<? super X> field, Class<? extends Annotation> annotationType) {
        return this.removeFromField(field.getJavaMember(), annotationType);
    }
}

