/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.infinispan.cdi.common.util.AnyLiteral;
import org.infinispan.cdi.common.util.DefaultLiteral;
import org.infinispan.cdi.common.util.ImmutableInjectionPoint;
import org.infinispan.cdi.common.util.Reflections;

public class Beans {
    private Beans() {
    }

    public static Set<Annotation> buildQualifiers(Set<Annotation> annotations) {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>(annotations);
        if (annotations.isEmpty()) {
            qualifiers.add((Annotation)DefaultLiteral.INSTANCE);
        }
        qualifiers.add((Annotation)AnyLiteral.INSTANCE);
        return qualifiers;
    }

    public static void checkReturnValue(Object instance, Bean<?> bean, InjectionPoint injectionPoint, BeanManager beanManager) {
        if (instance == null && !Dependent.class.equals((Object)bean.getScope())) {
            throw new IllegalStateException("Cannot return null from a non-dependent producer method: " + String.valueOf(bean));
        }
        if (instance != null) {
            boolean passivating = beanManager.isPassivatingScope(bean.getScope());
            boolean instanceSerializable = Reflections.isSerializable(instance.getClass());
            if (passivating && !instanceSerializable) {
                throw new IllegalStateException("Producers cannot declare passivating scope and return a non-serializable class: " + String.valueOf(bean));
            }
            if (injectionPoint != null && injectionPoint.getBean() != null && !instanceSerializable && beanManager.isPassivatingScope(injectionPoint.getBean().getScope())) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!injectionPoint.isTransient() && instance != null && !instanceSerializable) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans. Producer " + String.valueOf(bean) + "at injection point " + String.valueOf(injectionPoint));
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of initializers of beans declaring passivating scope. Producer " + String.valueOf(bean) + "at injection point " + String.valueOf(injectionPoint));
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope. Producer " + String.valueOf(bean) + "at injection point " + String.valueOf(injectionPoint));
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalStateException("Producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope. Producer " + String.valueOf(bean) + "at injection point " + String.valueOf(injectionPoint));
                }
            }
        }
    }

    public static <X> List<InjectionPoint> createInjectionPoints(AnnotatedMethod<X> method, Bean<?> declaringBean, BeanManager beanManager) {
        ArrayList<InjectionPoint> injectionPoints = new ArrayList<InjectionPoint>();
        for (AnnotatedParameter parameter : method.getParameters()) {
            ImmutableInjectionPoint injectionPoint = new ImmutableInjectionPoint(parameter, beanManager, declaringBean, false, false);
            injectionPoints.add(injectionPoint);
        }
        return injectionPoints;
    }
}

