/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cdi.util.defaultbean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;
import org.infinispan.cdi.util.ForwardingObserverMethod;
import org.infinispan.cdi.util.InjectableMethod;
import org.infinispan.cdi.util.ParameterValueRedefiner;

class DefaultObserverMethod<T, X>
extends ForwardingObserverMethod<T> {
    private final ObserverMethod<T> originalObserverMethod;
    private final InjectableMethod<X> observerMethod;
    private final BeanManager beanManager;
    private final Type declaringBeanType;
    private final Annotation[] declaringBeanQualifiers;
    private final Set<Annotation> qualifiers;
    private static final Annotation[] EMPTY_QUALIFIER_ARRAY = new Annotation[0];

    static <T, X> DefaultObserverMethod<T, X> of(ObserverMethod<T> originalObserverMethod, AnnotatedMethod<X> observerMethod, Set<Annotation> declaringBeanQualifiers, Set<Annotation> qualifiers, Bean<?> defaultBean, BeanManager beanManager) {
        return new DefaultObserverMethod<T, X>(originalObserverMethod, observerMethod, declaringBeanQualifiers, qualifiers, defaultBean, beanManager);
    }

    DefaultObserverMethod(ObserverMethod<T> originalObserverMethod, AnnotatedMethod<X> observerMethod, Set<Annotation> declaringBeanQualifiers, Set<Annotation> qualifiers, Bean<?> defaultBean, BeanManager beanManager) {
        this.originalObserverMethod = originalObserverMethod;
        this.observerMethod = new InjectableMethod<X>(observerMethod, defaultBean, beanManager);
        this.beanManager = beanManager;
        this.declaringBeanQualifiers = declaringBeanQualifiers.toArray(EMPTY_QUALIFIER_ARRAY);
        this.declaringBeanType = originalObserverMethod.getBeanClass();
        this.qualifiers = qualifiers;
    }

    @Override
    protected ObserverMethod<T> delegate() {
        return this.originalObserverMethod;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this.qualifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(final T event) {
        Bean declaringBean = this.beanManager.resolve(this.beanManager.getBeans(this.declaringBeanType, this.declaringBeanQualifiers));
        final CreationalContext<?> creationalContext = this.createCreationalContext(declaringBean);
        try {
            Object instance = this.beanManager.getReference(declaringBean, this.declaringBeanType, creationalContext);
            if (instance == null) {
                return;
            }
            this.observerMethod.invoke(instance, creationalContext, new ParameterValueRedefiner(){

                @Override
                public Object redefineParameterValue(ParameterValueRedefiner.ParameterValue value) {
                    if (value.getInjectionPoint().getAnnotated().isAnnotationPresent(Observes.class)) {
                        return event;
                    }
                    return value.getDefaultValue(creationalContext);
                }
            });
        }
        finally {
            if (creationalContext != null) {
                creationalContext.release();
            }
        }
    }

    private CreationalContext<?> createCreationalContext(Bean<?> declaringBean) {
        if (this.getReception().equals((Object)Reception.ALWAYS)) {
            return this.beanManager.createCreationalContext(declaringBean);
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DefaultObserverMethod) {
            DefaultObserverMethod that = (DefaultObserverMethod)obj;
            return this.delegate().equals(that.delegate()) && this.getObservedType().equals(that.getObservedType()) && this.getObservedQualifiers().equals(that.getObservedQualifiers());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 2;
        hash = 31 * hash + this.getObservedType().hashCode();
        hash = 31 * hash + this.getObservedQualifiers().hashCode();
        return hash;
    }
}

