/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.exception.CounterException;

abstract class BaseCounterOperation<T>
extends RetryOnFailureOperation<T> {
    private static final Log commonsLog = LogFactory.getLog(BaseCounterOperation.class, Log.class);
    private static final byte[] EMPTY_CACHE_NAME = Util.EMPTY_BYTE_ARRAY;
    private static final byte[] COUNTER_CACHE_NAME = RemoteCacheManager.cacheNameBytes("org.infinispan.counter");
    private final String counterName;

    BaseCounterOperation(short requestCode, short responseCode, Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName) {
        super(requestCode, responseCode, codec, channelFactory, EMPTY_CACHE_NAME, topologyId, 0, cfg, null);
        this.counterName = counterName;
    }

    void sendHeaderAndCounterNameAndRead(Channel channel, short opCode) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 0);
        channel.writeAndFlush((Object)buf);
    }

    ByteBuf getHeaderAndCounterNameBufferAndRead(Channel channel, int extraBytes) {
        this.scheduleRead(channel);
        byte[] counterBytes = this.counterName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(counterBytes) + extraBytes);
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeString(buf, this.counterName);
        this.setCacheName();
        return buf;
    }

    void checkStatus(short status) {
        if (status == 2) {
            throw commonsLog.undefinedCounter(this.counterName);
        }
    }

    void setCacheName() {
        this.header.cacheName(COUNTER_CACHE_NAME);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        this.channelFactory.fetchChannelAndInvoke(failedServers, COUNTER_CACHE_NAME, this);
    }

    @Override
    protected Throwable handleException(Throwable cause, ChannelHandlerContext ctx, SocketAddress address) {
        if ((cause = super.handleException(cause, ctx, address)) instanceof CounterException) {
            this.completeExceptionally(cause);
            return null;
        }
        return cause;
    }

    @Override
    protected void addParams(StringBuilder sb) {
        sb.append("counter=").append(this.counterName);
    }
}

