/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;

public class BytesOnlyJBossLikeMarshaller
implements Marshaller {
    public static BytesOnlyJBossLikeMarshaller INSTANCE = new BytesOnlyJBossLikeMarshaller();
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int ID_NULL = 1;
    private static final int ID_PRIM_BYTE = 33;
    private static final int ID_ARRAY_EMPTY_UNSHARED = 69;
    private static final int ID_ARRAY_SMALL_UNSHARED = 70;
    private static final int ID_ARRAY_MEDIUM_UNSHARED = 71;
    private static final int ID_ARRAY_LARGE_UNSHARED = 72;
    private static final ByteArrayEstimator BYTE_ARRAY_ESTIMATOR = new ByteArrayEstimator();

    private BytesOnlyJBossLikeMarshaller() {
    }

    private void checkByteArray(Object o) {
        if (!(o instanceof byte[])) {
            throw new IllegalArgumentException("Only byte[] instances are supported currently!");
        }
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        this.checkByteArray(obj);
        return this.serialize((byte[])obj);
    }

    public byte[] objectToByteBuffer(Object obj) {
        this.checkByteArray(obj);
        return this.serialize((byte[])obj);
    }

    public Object objectFromByteBuffer(byte[] buf) {
        return this.deserialize(buf, 0, buf.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
        return this.deserialize(buf, offset, length);
    }

    public ByteBuffer objectToBuffer(Object o) {
        this.checkByteArray(o);
        return new ByteBufferImpl(this.serialize((byte[])o));
    }

    public boolean isMarshallable(Object o) {
        return o instanceof byte[];
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return BYTE_ARRAY_ESTIMATOR;
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_JBOSS_MARSHALLING;
    }

    private byte[] serialize(byte[] bytes) {
        byte[] result;
        if (bytes == null) {
            return new byte[]{1};
        }
        int len = bytes.length;
        if (len == 0) {
            result = new byte[]{69, 33};
        } else if (len <= 256) {
            result = new byte[3 + len];
            result[0] = 70;
            result[1] = (byte)len;
            result[2] = 33;
            System.arraycopy(bytes, 0, result, 3, len);
        } else if (len <= 65536) {
            result = new byte[4 + len];
            result[0] = 71;
            result[1] = (byte)(len >> 8);
            result[2] = (byte)len;
            result[3] = 33;
            System.arraycopy(bytes, 0, result, 4, len);
        } else {
            result = new byte[6 + len];
            result[0] = 72;
            result[1] = (byte)(len >> 24);
            result[2] = (byte)(len >> 16);
            result[3] = (byte)(len >> 8);
            result[4] = (byte)len;
            result[5] = 33;
            System.arraycopy(bytes, 0, result, 6, len);
        }
        return result;
    }

    private byte[] deserialize(byte[] bytes, int offset, int len) {
        byte[] result;
        byte id = bytes[offset];
        switch (id) {
            case 1: {
                result = null;
                break;
            }
            case 69: {
                result = EMPTY_BYTE_ARRAY;
                break;
            }
            case 70: {
                int size = bytes[offset + 1] & 0xFF;
                assert (size == len - 3);
                result = new byte[size];
                System.arraycopy(bytes, offset + 3, result, 0, result.length);
                break;
            }
            case 71: {
                int size = (bytes[offset + 1] & 0xFF) << 8 | bytes[offset + 2] & 0xFF;
                assert (size == len - 4);
                result = new byte[size];
                System.arraycopy(bytes, offset + 4, result, 0, result.length);
                break;
            }
            case 72: {
                int size = (bytes[offset + 1] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 3] & 0xFF) << 8 | bytes[offset + 4] & 0xFF;
                assert (size == len - 6);
                result = new byte[size];
                System.arraycopy(bytes, offset + 6, result, 0, result.length);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported id: " + id);
            }
        }
        return result;
    }

    private static final class ByteArrayEstimator
    implements BufferSizePredictor {
        private ByteArrayEstimator() {
        }

        public int nextSize(Object obj) {
            byte[] bytes = (byte[])obj;
            int len = bytes.length;
            if (len == 0) {
                return 2;
            }
            if (len < 256) {
                return 3 + len;
            }
            if (len < 65536) {
                return 4 + len;
            }
            return 6 + len;
        }

        public void recordSize(int previousSize) {
        }
    }
}

