/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.CacheManagerNotStartedTest", groups={"functional"})
public class CacheManagerNotStartedTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration().build());
        return this.cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build(), false);
    }

    @AfterClass
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testGetCacheOperations() {
        assert (this.remoteCacheManager.getCache() != null);
        assert (this.remoteCacheManager.getCache(CACHE_NAME) != null);
        assert (!this.remoteCacheManager.isStarted());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGetCacheOperations2() {
        this.remoteCacheManager.getCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGetCacheOperations3() {
        this.remoteCacheManager.getCache(CACHE_NAME).put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPut() {
        this.remoteCache().put((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAsync() {
        this.remoteCache().putAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testGet() {
        this.remoteCache().get((Object)"k");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testReplace() {
        this.remoteCache().replace((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testReplaceAsync() {
        this.remoteCache().replaceAsync((Object)"k", (Object)"v");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAll() {
        this.remoteCache().putAll(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testPutAllAsync() {
        this.remoteCache().putAllAsync(new HashMap());
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedGet() {
        this.remoteCache().getVersioned((Object)"key");
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedRemove() {
        this.remoteCache().removeWithVersion((Object)"key", 12312321L);
    }

    @Test(expectedExceptions={RemoteCacheManagerNotStartedException.class})
    public void testVersionedRemoveAsync() {
        this.remoteCache().removeWithVersionAsync((Object)"key", 12312321L);
    }

    private RemoteCache<Object, Object> remoteCache() {
        return this.remoteCacheManager.getCache();
    }
}

