/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.Exceptions;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientSocketReadTimeoutTest", groups={"functional"})
public class ClientSocketReadTimeoutTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    RemoteCacheManager remoteCacheManager;
    CyclicBarrier barrier;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.barrier = new CyclicBarrier(2);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        BlockingInterceptor blockingInterceptor = new BlockingInterceptor(this.barrier, PutKeyValueCommand.class, true, true);
        this.cacheManager.getCache().getAdvancedCache().getAsyncInterceptorChain().addInterceptorBefore((AsyncInterceptor)blockingInterceptor, EntryWrappingInterceptor.class);
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder(this.hotrodServer).socketTimeout(1000).connectionTimeout(5000).connectionPool().maxActive(2).maxRetries(0);
        return new RemoteCacheManager(builder.create());
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    public void testPutTimeout(Method m) throws Throwable {
        Exceptions.expectException(TransportException.class, SocketTimeoutException.class, () -> this.remoteCacheManager.getCache().put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m)));
        this.barrier.await(10L, TimeUnit.SECONDS);
        this.barrier.await(10L, TimeUnit.SECONDS);
    }
}

