/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExpiryTest")
public class ExpiryTest
extends MultiHotRodServersTest {
    public static final int EXPIRATION_TIMEOUT = 6000;
    private ControlledTimeService timeService;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ExpiryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        builder.expiration().lifespan(6000L);
        this.createHotRodServers(1, builder);
        this.timeService = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)((CacheContainer)this.cacheManagers.get(0)), TimeService.class, (Object)this.timeService, (boolean)true);
    }

    public void testGlobalExpiryPut() {
        RemoteCache cache0 = this.client(0).getCache();
        Req.PUT.execute((RemoteCache<Integer, String>)cache0, 0, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 0, "v0");
    }

    public void testGlobalExpiryPutWithFlag() {
        RemoteCache cache0 = this.client(0).getCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        Req.PUT.execute((RemoteCache<Integer, String>)cache0, 1, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 1, "v0");
    }

    public void testGlobalExpiryPutAll() {
        RemoteCache cache0 = this.client(0).getCache();
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(2, "v0");
        Req.PUT_ALL.execute((RemoteCache<Integer, String>)cache0, data);
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 2, "v0");
    }

    public void testGlobalExpiryPutAllWithFlag() {
        RemoteCache cache0 = this.client(0).getCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        HashMap<Integer, String> data = new HashMap<Integer, String>();
        data.put(3, "v0");
        Req.PUT_ALL.execute((RemoteCache<Integer, String>)cache0, data);
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 3, "v0");
    }

    public void testGlobalExpiryPutIfAbsent() {
        RemoteCache cache0 = this.client(0).getCache();
        Req.PUT_IF_ABSENT.execute((RemoteCache<Integer, String>)cache0, 4, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 4, "v0");
    }

    public void testGlobalExpiryPutIfAbsentWithFlag() {
        RemoteCache cache0 = this.client(0).getCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        Req.PUT_IF_ABSENT.execute((RemoteCache<Integer, String>)cache0, 5, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 5, "v0");
    }

    public void testGlobalExpiryReplace() {
        RemoteCache cache0 = this.client(0).getCache();
        cache0.put((Object)6, (Object)"v1");
        Req.REPLACE.execute((RemoteCache<Integer, String>)cache0, 6, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 6, "v0");
    }

    public void testGlobalExpiryReplaceFlag() {
        RemoteCache cache0 = this.client(0).getCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        cache0.put((Object)7, (Object)"v1");
        Req.REPLACE.execute((RemoteCache<Integer, String>)cache0, 7, "v0");
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 7, "v0");
    }

    public void testGlobalExpiryReplaceWithVersion() {
        this.client(0).getCache().put((Object)8, (Object)"v0");
        long version = this.client(0).getCache().getVersioned((Object)8).getVersion();
        RemoteCache cache0 = this.client(0).getCache();
        Req.REPLACE_WITH_VERSION.execute((RemoteCache<Integer, String>)cache0, 8, "v1", version);
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 8, "v1");
    }

    public void testGlobalExpiryReplaceWithVersionFlag() {
        this.client(0).getCache().put((Object)9, (Object)"v0");
        long version = this.client(0).getCache().getVersioned((Object)9).getVersion();
        RemoteCache cache0 = this.client(0).getCache();
        Req.REPLACE_WITH_VERSION.execute((RemoteCache<Integer, String>)this.client(0).getCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}), 9, "v1", version);
        this.expectCachedThenExpired((RemoteCache<Integer, String>)cache0, 9, "v1");
    }

    private void expectCachedThenExpired(RemoteCache<Integer, String> cache, int key, String value) {
        AssertJUnit.assertEquals((String)value, (String)((String)cache.get((Object)key)));
        this.timeService.advance(6100L);
        AssertJUnit.assertNull((Object)cache.get((Object)key));
    }

    public void testLifespanMaxIdleOverflow() {
        long time = 2147484L;
        this.client(0).getCache().put((Object)10, (Object)"v0", time, TimeUnit.SECONDS, time, TimeUnit.SECONDS);
        MetadataValue withMetadata = this.client(0).getCache().getWithMetadata((Object)10);
        AssertJUnit.assertEquals((long)time, (long)withMetadata.getLifespan());
        AssertJUnit.assertEquals((long)time, (long)withMetadata.getMaxIdle());
    }

    private static enum Req {
        PUT{

            @Override
            void execute(RemoteCache<Integer, String> c, int key, String value) {
                c.put((Object)key, (Object)value);
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            void execute(RemoteCache<Integer, String> c, int key, String value) {
                c.putIfAbsent((Object)key, (Object)value);
            }
        }
        ,
        PUT_ALL{

            @Override
            void execute(RemoteCache<Integer, String> c, Map<Integer, String> data) {
                c.putAll(data);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(RemoteCache<Integer, String> c, int key, String value) {
                c.replace((Object)key, (Object)value);
            }
        }
        ,
        REPLACE_WITH_VERSION{

            @Override
            void execute(RemoteCache<Integer, String> c, int key, String value, Long version) {
                c.replaceWithVersion((Object)key, (Object)value, version.longValue());
            }
        };


        void execute(RemoteCache<Integer, String> c, int key, String value, Long version) {
            this.execute(c, key, value, version);
        }

        void execute(RemoteCache<Integer, String> c, int key, String value) {
            this.execute(c, key, value);
        }

        void execute(RemoteCache<Integer, String> c, Map<Integer, String> data) {
            this.execute(c, data);
        }
    }
}

