/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.ReplListener;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodAsyncReplicationTest")
public class HotRodAsyncReplicationTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)HotRodAsyncReplicationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_ASYNC, (boolean)false));
        builder.memory().size(3L);
        this.createHotRodServers(2, builder);
    }

    public void testPutKeyValue(Method m) {
        RemoteCache remoteCache0 = this.client(0).getCache();
        RemoteCache remoteCache1 = this.client(1).getCache();
        ReplListener replList0 = this.getReplListener(0);
        ReplListener replList1 = this.getReplListener(1);
        replList0.expect(PutKeyValueCommand.class);
        replList1.expect(PutKeyValueCommand.class);
        String v1 = TestingUtil.v((Method)m);
        remoteCache0.put((Object)1, (Object)v1);
        replList0.waitForRpc();
        replList1.waitForRpc();
        AssertJUnit.assertEquals((Object)v1, (Object)remoteCache1.get((Object)1));
        AssertJUnit.assertEquals((Object)v1, (Object)remoteCache1.get((Object)1));
        AssertJUnit.assertEquals((Object)v1, (Object)remoteCache0.get((Object)1));
        AssertJUnit.assertEquals((Object)v1, (Object)remoteCache0.get((Object)1));
    }

    private ReplListener getReplListener(int cacheIndex) {
        ReplListener replList = (ReplListener)this.listeners.get(this.cache(cacheIndex));
        if (replList == null) {
            replList = new ReplListener(this.cache(cacheIndex), true, true);
        } else {
            replList.reconfigureListener(true);
        }
        return replList;
    }
}

