/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.MultipleCacheTopologyChangeTest", groups={"functional"})
public class MultipleCacheTopologyChangeTest
extends MultipleCacheManagersTest {
    private final List<Node> nodes = new ArrayList<Node>();
    private RemoteCacheManager client;

    public void testRoundRobinLoadBalancing() throws InterruptedException, IOException {
        String[] caches = new String[]{"cache1", "cache2"};
        Node nodeA = this.startNewNode(caches);
        Node nodeB = this.startNewNode(caches);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServers(this.getServerList(nodeA, nodeB));
        this.client = new RemoteCacheManager(clientBuilder.build());
        RemoteCache cache1 = this.client.getCache("cache1");
        RemoteCache cache2 = this.client.getCache("cache2");
        this.startNewNode(caches);
        nodeB.kill();
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        AssertJUnit.assertTrue((boolean)cache2.isEmpty());
        nodeA.kill();
        AssertJUnit.assertTrue((boolean)cache1.isEmpty());
        AssertJUnit.assertTrue((boolean)cache2.isEmpty());
    }

    private String getServerList(Node ... nodes) {
        return String.join((CharSequence)";", Arrays.stream(nodes).map(n -> "127.0.0.1:" + n.getPort()).collect(Collectors.toSet()));
    }

    protected void createCacheManagers() throws Throwable {
    }

    private Node startNewNode(String ... caches) {
        Node node = new Node(caches);
        node.start();
        this.waitForClusterToForm();
        this.nodes.add(node);
        return node;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder c = new org.infinispan.configuration.cache.ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.DIST_SYNC);
        return c;
    }

    @AfterClass
    protected void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.client);
        this.nodes.forEach(Node::kill);
    }

    class Node {
        private final String[] cacheNames;
        HotRodServer server;
        EmbeddedCacheManager cacheManager;
        private boolean stopped;

        public Node(String ... cacheNames) {
            this.cacheNames = cacheNames;
        }

        public void start() {
            this.cacheManager = TestCacheManagerFactory.createClusteredCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultipleCacheTopologyChangeTest.this.getConfigurationBuilder()));
            MultipleCacheTopologyChangeTest.this.registerCacheManager(new CacheContainer[]{this.cacheManager});
            Arrays.stream(this.cacheNames).forEach(cacheName -> {
                this.cacheManager.defineConfiguration(cacheName, MultipleCacheTopologyChangeTest.this.getConfigurationBuilder().build());
                this.cacheManager.getCache(cacheName);
            });
            this.server = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
            MultipleCacheTopologyChangeTest.this.waitForClusterToForm(this.cacheNames);
        }

        public int getPort() {
            return this.server.getPort();
        }

        void kill() {
            if (!this.stopped) {
                if (this.server != null) {
                    HotRodClientTestingUtil.killServers(this.server);
                }
                TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
                this.stopped = true;
            }
        }
    }
}

