/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collection;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.multimap.MetadataCollection;
import org.infinispan.client.hotrod.multimap.MultimapCacheManager;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCache;
import org.infinispan.client.hotrod.multimap.RemoteMultimapCacheManagerFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.RemoteMultimapCacheAPITest")
public class RemoteMultimapCacheAPITest
extends SingleHotRodServerTest {
    private RemoteMultimapCache<String, String> mutimapCache;

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.forceReturnValues(this.isForceReturnValuesViaConfiguration());
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Override
    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
        this.hotrodServer = this.createHotRodServer();
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCacheManager.start();
        MultimapCacheManager rmc = RemoteMultimapCacheManagerFactory.from((RemoteCacheManager)this.remoteCacheManager);
        this.mutimapCache = rmc.get("");
    }

    protected boolean isForceReturnValuesViaConfiguration() {
        return true;
    }

    public void testGetNotExist() throws Exception {
        Collection kValues = (Collection)this.mutimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)0, (int)kValues.size());
    }

    public void testGetWithMetadataNotExist() throws Exception {
        MetadataCollection k = (MetadataCollection)this.mutimapCache.getWithMetadata((Object)"k").join();
        AssertJUnit.assertEquals((int)0, (int)k.getCollection().size());
    }

    public void testPut() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        this.mutimapCache.put((Object)"k", (Object)"b").join();
        this.mutimapCache.put((Object)"k", (Object)"c").join();
        Collection kValues = (Collection)this.mutimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)3, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)kValues.contains("a"));
        AssertJUnit.assertTrue((boolean)kValues.contains("b"));
        AssertJUnit.assertTrue((boolean)kValues.contains("c"));
    }

    public void testPutWithDuplicates() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        Collection kValues = (Collection)this.mutimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)1, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)kValues.contains("a"));
    }

    public void testGetWithMetadata() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        MetadataCollection metadataCollection = (MetadataCollection)this.mutimapCache.getWithMetadata((Object)"k").join();
        AssertJUnit.assertEquals((int)1, (int)metadataCollection.getCollection().size());
        AssertJUnit.assertTrue((boolean)metadataCollection.getCollection().contains("a"));
        AssertJUnit.assertEquals((int)-1, (int)metadataCollection.getLifespan());
        AssertJUnit.assertEquals((long)0L, (long)metadataCollection.getVersion());
    }

    public void testRemoveKey() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        Collection kValues = (Collection)this.mutimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)1, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)kValues.contains("a"));
        AssertJUnit.assertTrue((boolean)((Boolean)this.mutimapCache.remove((Object)"k").join()));
        AssertJUnit.assertEquals((int)0, (int)((Collection)this.mutimapCache.get((Object)"k").join()).size());
        AssertJUnit.assertFalse((boolean)((Boolean)this.mutimapCache.remove((Object)"k").join()));
    }

    public void testRemoveKeyValue() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        this.mutimapCache.put((Object)"k", (Object)"b").join();
        this.mutimapCache.put((Object)"k", (Object)"c").join();
        Collection kValues = (Collection)this.mutimapCache.get((Object)"k").join();
        AssertJUnit.assertEquals((int)3, (int)kValues.size());
        AssertJUnit.assertTrue((boolean)((Boolean)this.mutimapCache.remove((Object)"k", (Object)"a").join()));
        AssertJUnit.assertEquals((int)2, (int)((Collection)this.mutimapCache.get((Object)"k").join()).size());
    }

    public void testSize() throws Exception {
        AssertJUnit.assertEquals((Object)0L, this.mutimapCache.size().join());
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        AssertJUnit.assertEquals((Object)1L, this.mutimapCache.size().join());
        this.mutimapCache.put((Object)"k", (Object)"b").join();
        AssertJUnit.assertEquals((Object)2L, this.mutimapCache.size().join());
    }

    public void testContainsEntry() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        AssertJUnit.assertTrue((boolean)((Boolean)this.mutimapCache.containsEntry((Object)"k", (Object)"a").join()));
        AssertJUnit.assertFalse((boolean)((Boolean)this.mutimapCache.containsEntry((Object)"k", (Object)"b").join()));
    }

    public void testContainsKey() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        AssertJUnit.assertTrue((boolean)((Boolean)this.mutimapCache.containsKey((Object)"k").join()));
        AssertJUnit.assertFalse((boolean)((Boolean)this.mutimapCache.containsKey((Object)"l").join()));
    }

    public void testContainsValue() throws Exception {
        this.mutimapCache.put((Object)"k", (Object)"a").join();
        AssertJUnit.assertTrue((boolean)((Boolean)this.mutimapCache.containsValue((Object)"a").join()));
        AssertJUnit.assertFalse((boolean)((Boolean)this.mutimapCache.containsValue((Object)"b").join()));
    }
}

