/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.RoundRobinBalancingStrategyTest")
public class RoundRobinBalancingStrategyTest
extends AbstractInfinispanTest {
    SocketAddress addr1 = new InetSocketAddress("localhost", 1111);
    SocketAddress addr2 = new InetSocketAddress("localhost", 2222);
    SocketAddress addr3 = new InetSocketAddress("localhost", 3333);
    SocketAddress addr4 = new InetSocketAddress("localhost", 4444);
    private List<SocketAddress> defaultServers;
    private RoundRobinBalancingStrategy strategy;

    @BeforeMethod
    public void setUp() {
        this.strategy = new RoundRobinBalancingStrategy();
        this.defaultServers = new ArrayList<SocketAddress>();
        this.defaultServers.add(this.addr1);
        this.defaultServers.add(this.addr2);
        this.defaultServers.add(this.addr3);
        this.strategy.setServers(this.defaultServers);
    }

    public void simpleTest() {
        this.expectServerEventually(this.addr1, this.defaultServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
    }

    public void testAddServer() {
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.add(this.addr4);
        this.strategy.setServers(newServers);
        this.expectServerEventually(this.addr1, newServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
    }

    public void testRemoveServer() {
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.remove(this.addr3);
        this.strategy.setServers(newServers);
        this.expectServerEventually(this.addr1, newServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
    }

    public void testRemoveServerAfterActivity() {
        this.expectServerEventually(this.addr1, this.defaultServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.remove(this.addr3);
        this.strategy.setServers(newServers);
        this.expectServerEventually(this.addr1, newServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
    }

    public void testAddServerAfterActivity() {
        this.expectServerEventually(this.addr1, this.defaultServers, null);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.add(this.addr4);
        this.strategy.setServers(newServers);
        this.expectServerEventually(this.addr3, newServers, null);
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(null));
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer(null));
    }

    public void testFailedServers1() {
        this.strategy.setServers(this.defaultServers);
        Set<SocketAddress> failedServers = Collections.singleton(this.addr1);
        int LOOPS = 10;
        int c1 = 0;
        int c2 = 0;
        for (int i = 0; i < 10; ++i) {
            SocketAddress server = this.strategy.nextServer(failedServers);
            AssertJUnit.assertNotNull((Object)server);
            AssertJUnit.assertNotSame((Object)this.addr1, (Object)server);
            if (server.equals(this.addr2)) {
                ++c1;
                continue;
            }
            if (!server.equals(this.addr3)) continue;
            ++c2;
        }
        AssertJUnit.assertEquals((int)10, (int)(c1 + c2));
        AssertJUnit.assertTrue((Math.abs(c1 - c2) <= 1 ? 1 : 0) != 0);
    }

    public void testFailedServers2() {
        this.strategy.setServers(this.defaultServers);
        HashSet<SocketAddress> failedServers = new HashSet<SocketAddress>(this.defaultServers);
        this.expectServerEventually(this.addr1, this.defaultServers, failedServers);
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer(failedServers));
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer(failedServers));
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer(failedServers));
    }

    private void expectServerEventually(SocketAddress addr, List<SocketAddress> servers, Set<SocketAddress> failedServers) {
        for (int i = 0; i < servers.size(); ++i) {
            if (!addr.equals(this.strategy.nextServer(failedServers))) continue;
            return;
        }
        AssertJUnit.fail((String)("Did not get server " + addr + " after " + servers.size() + " attempts"));
    }
}

