/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.io.File;
import java.lang.reflect.Method;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.RemoteCacheAdminPermanentTest")
public class RemoteCacheAdminPermanentTest
extends MultiHotRodServersTest {
    char serverId;
    boolean clear = true;

    protected void createCacheManagers() throws Throwable {
        this.serverId = (char)65;
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)RemoteCacheAdminPermanentTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.createHotRodServers(2, builder);
    }

    @Override
    protected HotRodServer addHotRodServer(ConfigurationBuilder builder) {
        char c = this.serverId;
        this.serverId = (char)(c + '\u0001');
        return this.addStatefulHotRodServer(builder, c);
    }

    protected boolean isShared() {
        return false;
    }

    protected HotRodServer addStatefulHotRodServer(ConfigurationBuilder builder, char id) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        String stateDirectory = TestingUtil.tmpDirectory((String)(((Object)((Object)this)).getClass().getSimpleName() + File.separator + id));
        if (this.clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        gcb.globalState().enable().persistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        if (this.isShared()) {
            String sharedDirectory = TestingUtil.tmpDirectory((String)(((Object)((Object)this)).getClass().getSimpleName() + File.separator + "COMMON"));
            gcb.globalState().sharedPersistentLocation(sharedDirectory);
        } else {
            gcb.globalState().sharedPersistentLocation(stateDirectory);
        }
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(gcb, builder);
        cm.defineConfiguration("template", builder.build());
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        this.servers.add(server);
        return server;
    }

    public void permanentCacheTest(Method m) throws Throwable {
        String cacheName = m.getName();
        ((RemoteCacheManagerAdmin)this.client(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.PERMANENT})).createCache(cacheName, "template");
        AssertJUnit.assertTrue((boolean)this.manager(0).cacheExists(cacheName));
        AssertJUnit.assertTrue((boolean)this.manager(1).cacheExists(cacheName));
        this.killAll();
        this.clear = false;
        this.createCacheManagers();
        AssertJUnit.assertTrue((boolean)this.manager(0).cacheExists(cacheName));
        ((RemoteCacheManagerAdmin)this.client(0).administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.PERMANENT})).removeCache(cacheName);
        this.killAll();
        this.clear = false;
        this.createCacheManagers();
        AssertJUnit.assertFalse((boolean)this.manager(0).cacheExists(cacheName));
    }
}

