/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.testdomain.protobuf.TransactionPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.embedded.testdomain.Transaction;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.RemoteCacheAdminTest")
public class RemoteCacheAdminTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)RemoteCacheAdminTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().index(Index.ALL).autoConfig(true);
        this.createHotRodServers(2, builder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        builder.marshaller((Marshaller)new ProtoStreamMarshaller());
        return builder;
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.defaultCacheName("default");
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(gcb, builder);
        cm.defineConfiguration("template", builder.build());
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        this.servers.add(server);
        return server;
    }

    public void cacheCreateRemoveTest(Method m) {
        String cacheName = m.getName();
        this.client(0).administration().createCache(cacheName, "template");
        AssertJUnit.assertTrue((boolean)this.manager(0).cacheExists(cacheName));
        AssertJUnit.assertTrue((boolean)this.manager(1).cacheExists(cacheName));
        this.client(1).administration().removeCache(cacheName);
        AssertJUnit.assertFalse((boolean)this.manager(0).cacheExists(cacheName));
        AssertJUnit.assertFalse((boolean)this.manager(1).cacheExists(cacheName));
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN000374.*")
    public void nonExistentTemplateTest(Method m) {
        String cacheName = m.getName();
        this.client(0).administration().createCache(cacheName, "nonExistentTemplate");
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN000507.*")
    public void alreadyExistingCacheTest(Method m) {
        String cacheName = m.getName();
        this.client(0).administration().createCache(cacheName, "template");
        this.client(0).administration().createCache(cacheName, "template");
    }

    public void getOrCreateWithTemplateTest(Method m) {
        String cacheName = m.getName();
        this.client(0).administration().createCache(cacheName, "template");
        this.client(0).administration().getOrCreateCache(cacheName, "template");
    }

    public void getOrCreateWithoutTemplateTest() {
        this.client(0).administration().getOrCreateCache("default", (String)null);
    }

    public void cacheCreateWithXMLConfigurationTest(Method m) {
        String cacheName = m.getName();
        String xml = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"><encoding><key media-type=\"text/plain\"/><value media-type=\"application/json\"/></encoding><expiration interval=\"10000\" lifespan=\"10\" max-idle=\"10\"/></distributed-cache></cache-container></infinispan>", cacheName);
        this.client(0).administration().getOrCreateCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(xml));
        Configuration configuration = this.manager(0).getCache(cacheName).getCacheConfiguration();
        AssertJUnit.assertEquals((long)10000L, (long)configuration.expiration().wakeUpInterval());
        AssertJUnit.assertEquals((long)10L, (long)configuration.expiration().lifespan());
        AssertJUnit.assertEquals((long)10L, (long)configuration.expiration().maxIdle());
        AssertJUnit.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)configuration.encoding().keyDataType().mediaType());
        AssertJUnit.assertEquals((Object)MediaType.APPLICATION_JSON, (Object)configuration.encoding().valueDataType().mediaType());
    }

    public void cacheCreateWithXMLConfigurationAndGetCacheTest(Method m) {
        String cacheName = m.getName();
        String xml = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", cacheName);
        this.client(0).administration().createCache(cacheName, (BasicConfiguration)new XMLStringConfiguration(xml));
        RemoteCache cache = this.client(0).getCache(cacheName);
        AssertJUnit.assertNotNull((Object)cache);
    }

    public void cacheCreateWithEmbeddedConfigurationTest(Method m) {
        String cacheName = m.getName();
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.expiration().wakeUpInterval(10000L).maxIdle(10L).lifespan(10L);
        this.client(0).administration().getOrCreateCache(cacheName, (BasicConfiguration)builder.build());
        Configuration configuration = this.manager(0).getCache(cacheName).getCacheConfiguration();
        AssertJUnit.assertEquals((long)10000L, (long)configuration.expiration().wakeUpInterval());
        AssertJUnit.assertEquals((long)10L, (long)configuration.expiration().lifespan());
        AssertJUnit.assertEquals((long)10L, (long)configuration.expiration().maxIdle());
    }

    public void cacheReindexTest(Method m) throws IOException {
        String cacheName = m.getName();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(this.client(0));
        this.client(0).administration().createCache(cacheName, "template");
        RemoteCache cache = this.client(0).getCache(cacheName);
        TransactionPB tx = new TransactionPB();
        tx.setId(1);
        tx.setAccountId(777);
        tx.setAmount(500.0);
        tx.setDate(new Date(1L));
        tx.setDescription("February rent");
        tx.setLongDescription("February rent");
        tx.setNotes("card was not present");
        cache.withFlags(new Flag[]{Flag.SKIP_INDEXING}).put((Object)"tx", (Object)tx);
        this.verifyQuery((RemoteCache<String, Transaction>)cache, 0);
        this.client(0).administration().reindexCache(cacheName);
        this.verifyQuery((RemoteCache<String, Transaction>)cache, 1);
        this.client(0).administration().removeCache(cacheName);
    }

    private void verifyQuery(RemoteCache<String, Transaction> cache, int count) {
        List users = Search.getQueryFactory(cache).create("from sample_bank_account.Transaction where longDescription:'RENT'").list();
        AssertJUnit.assertEquals((int)count, (int)users.size());
    }

    public void testGetCacheNames(Method m) {
        String cacheName = m.getName();
        this.client(0).administration().createCache(cacheName, "template");
        Set cacheNames = this.client(0).getCacheNames();
        AssertJUnit.assertEquals((Object)this.manager(0).getCacheNames(), (Object)cacheNames);
    }
}

