/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.util.ByteString;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.counter.StrongCounterHitsAwareTest")
public class StrongCounterHitsAwareTest
extends HitsAwareCacheManagersTest {
    private static final int NUM_SERVERS = 3;

    public void testAddAndGetHits(Method method) {
        String counterName = method.getName();
        this.doTest(counterName, SyncStrongCounter::incrementAndGet);
    }

    public void testGetValueHits(Method method) {
        String counterName = method.getName();
        this.doTest(counterName, SyncStrongCounter::getValue);
    }

    public void testResetHits(Method method) {
        String counterName = method.getName();
        this.doTest(counterName, SyncStrongCounter::reset);
    }

    public void testCompareAndSwapHits(Method method) {
        String counterName = method.getName();
        this.doTest(counterName, counter -> counter.compareAndSwap(0L, 1L));
    }

    public void testRemoveHits(Method method) {
        String counterName = method.getName();
        this.doTest(counterName, SyncStrongCounter::remove);
    }

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, new ConfigurationBuilder());
        this.waitForClusterToForm("org.infinispan.COUNTER");
        this.addInterceptors("org.infinispan.COUNTER");
        AssertJUnit.assertEquals((int)3, (int)this.getCacheManagers().size());
    }

    @Override
    protected void resetStats() {
        this.caches("org.infinispan.COUNTER").stream().map(this::getHitCountInterceptor).forEach(HitsAwareCacheManagersTest.HitCountInterceptor::reset);
    }

    private void doTest(String counterName, Consumer<SyncStrongCounter> action) {
        this.defineCounter(counterName);
        int primaryOwner = this.findPrimaryOwnerIndex(counterName);
        this.resetStats();
        for (CounterManager cm : this.clientCounterManagers()) {
            action.accept(cm.getStrongCounter(counterName).sync());
        }
        this.assertHits(primaryOwner);
    }

    private void defineCounter(String counterName) {
        CounterManager counterManager = RemoteCounterManagerFactory.asCounterManager((RemoteCacheManager)this.client(0));
        counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).build());
        for (CounterManager cm : this.clientCounterManagers()) {
            cm.getStrongCounter(counterName).sync().incrementAndGet();
        }
    }

    private void assertHits(int primaryOwnerIndex) {
        for (int i = 0; i < 3; ++i) {
            Cache cache = this.cache(i, "org.infinispan.COUNTER");
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = this.getHitCountInterceptor(cache);
            if (i == primaryOwnerIndex) {
                AssertJUnit.assertEquals((String)"Wrong number of hits on primary owner", (int)3, (int)interceptor.getHits());
                continue;
            }
            AssertJUnit.assertEquals((String)("Wrong number of hits on " + this.address(i) + ". Primary owner is " + this.address(primaryOwnerIndex)), (int)0, (int)interceptor.getHits());
        }
    }

    private int findPrimaryOwnerIndex(String counterName) {
        CounterKey key = this.findCounterKey(counterName);
        for (int i = 0; i < 3; ++i) {
            Cache cache = this.cache(i, "org.infinispan.COUNTER");
            if (!cache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)key).isPrimary()) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private CounterKey findCounterKey(String counterName) {
        ByteString bs = ByteString.fromString((String)counterName);
        Cache cache = this.cache(0, "org.infinispan.COUNTER");
        ArrayList keys = new ArrayList(cache.keySet());
        for (CounterKey counterKey : keys) {
            if (!counterKey.getCounterName().equals((Object)bs)) continue;
            return counterKey;
        }
        throw new IllegalStateException();
    }

    private List<CounterManager> clientCounterManagers() {
        return this.clients.stream().map(RemoteCounterManagerFactory::asCounterManager).collect(Collectors.toList());
    }
}

