/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.event.ClientEventsTest")
public class ClientEventsTest
extends SingleHotRodServerTest {
    public void testCreatedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)2, (Object)"two");
            l.expectOnlyCreatedEvent(2);
        });
    }

    public void testModifiedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)1, (Object)"newone");
            l.expectOnlyModifiedEvent(1);
        });
    }

    public void testRemovedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.remove((Object)1);
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.remove((Object)1);
            l.expectOnlyRemovedEvent(1);
        });
    }

    public void testReplaceEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.replace((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.replace((Object)1, (Object)"newone");
            l.expectOnlyModifiedEvent(1);
        });
    }

    public void testPutIfAbsentEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.putIfAbsent((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.putIfAbsent((Object)1, (Object)"newone");
            l.expectNoEvents();
        });
    }

    public void testReplaceIfUnmodifiedEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.replaceWithVersion((Object)1, (Object)"one", 0L);
            l.expectNoEvents();
            remote.putIfAbsent((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.replaceWithVersion((Object)1, (Object)"one", 0L);
            l.expectNoEvents();
            VersionedValue versioned = remote.getVersioned((Object)1);
            remote.replaceWithVersion((Object)1, (Object)"one", versioned.getVersion());
            l.expectOnlyModifiedEvent(1);
        });
    }

    public void testRemoveIfUnmodifiedEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.removeWithVersion((Object)1, 0L);
            l.expectNoEvents();
            remote.putIfAbsent((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.removeWithVersion((Object)1, 0L);
            l.expectNoEvents();
            VersionedValue versioned = remote.getVersioned((Object)1);
            remote.removeWithVersion((Object)1, versioned.getVersion());
            l.expectOnlyRemovedEvent(1);
        });
    }

    public void testClearEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)2, (Object)"two");
            l.expectOnlyCreatedEvent(2);
            remote.put((Object)3, (Object)"three");
            l.expectOnlyCreatedEvent(3);
            remote.clear();
            l.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, 1, 2, 3);
        });
    }

    public void testNoEventsBeforeAddingListener() {
        RemoteCache rcache = this.remoteCacheManager.getCache();
        EventLogListener<Integer> l = new EventLogListener<Integer>(rcache);
        rcache.put((Object)1, (Object)"one");
        l.expectNoEvents();
        rcache.put((Object)1, (Object)"newone");
        l.expectNoEvents();
        rcache.remove((Object)1);
        l.expectNoEvents();
        this.createUpdateRemove(l);
    }

    private void createUpdateRemove(EventLogListener<Integer> l) {
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            remote.put((Object)1, (Object)"one");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)1, (Object)"newone");
            l.expectOnlyModifiedEvent(1);
            remote.remove((Object)1);
            l.expectOnlyRemovedEvent(1);
        });
    }

    public void testNoEventsAfterRemovingListener() {
        RemoteCache rcache = this.remoteCacheManager.getCache();
        EventLogListener<Integer> l = new EventLogListener<Integer>(rcache);
        this.createUpdateRemove(l);
        rcache.put((Object)1, (Object)"one");
        l.expectNoEvents();
        rcache.put((Object)1, (Object)"newone");
        l.expectNoEvents();
        rcache.remove((Object)1);
        l.expectNoEvents();
    }

    public void testSetListeners() {
        RemoteCache rcache = this.remoteCacheManager.getCache();
        EventLogListener l1 = new EventLogListener(rcache);
        HotRodClientTestingUtil.withClientListener(l1, remote1 -> {
            Set listeners1 = remote1.getListeners();
            AssertJUnit.assertEquals((int)1, (int)listeners1.size());
            AssertJUnit.assertEquals((Object)l1, listeners1.iterator().next());
            EventLogListener l2 = new EventLogListener(rcache);
            HotRodClientTestingUtil.withClientListener(l2, remote2 -> {
                Set listeners2 = remote2.getListeners();
                AssertJUnit.assertEquals((int)2, (int)listeners2.size());
                AssertJUnit.assertTrue((boolean)listeners2.contains(l1));
                AssertJUnit.assertTrue((boolean)listeners2.contains(l2));
            });
        });
        Set listeners = rcache.getListeners();
        AssertJUnit.assertEquals((int)0, (int)listeners.size());
    }

    public void testCustomTypeEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            CustomKey key = new CustomKey(1);
            remote.put((Object)key, (Object)"one");
            l.expectOnlyCreatedEvent(key);
            remote.replace((Object)key, (Object)"newone");
            l.expectOnlyModifiedEvent(key);
            remote.remove((Object)key);
            l.expectOnlyRemovedEvent(key);
        });
    }

    public void testEventReplayAfterAddingListener() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        WithStateEventLogListener l = new WithStateEventLogListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        l.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(l, remote -> l.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, 1, 2));
    }

    public void testNoEventReplayAfterAddingListener() {
        RemoteCache cache = this.remoteCacheManager.getCache();
        EventLogListener l = new EventLogListener(cache);
        cache.put((Object)1, (Object)"one");
        cache.put((Object)2, (Object)"two");
        l.expectNoEvents();
        HotRodClientTestingUtil.withClientListener(l, remote -> l.expectNoEvents());
    }

    static final class CustomKey
    implements Serializable {
        final int id;

        CustomKey(int id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomKey customKey = (CustomKey)o;
            return this.id == customKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends EventLogListener<K> {
        public WithStateEventLogListener(RemoteCache<K, ?> remote) {
            super(remote);
        }
    }
}

