/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerWithIndexingAndProtobufTest")
public class ClientListenerWithIndexingAndProtobufTest
extends MultiHotRodServersTest {
    private final int NUM_NODES = 2;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ClientListenerWithIndexingAndProtobufTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        this.remoteCache = this.client(0).getCache();
        RemoteCache metadataCache = this.client(0).getCache("___protobuf_metadata");
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        MarshallerRegistration.registerMarshallers(this.client(0));
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        return super.createHotRodClientConfigurationBuilder(host, serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testEventFilter() throws Exception {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        NoopEventListener listener = new NoopEventListener();
        this.remoteCache.addClientListener((Object)listener);
        this.expectElementsInQueue(listener.createEvents, 0);
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        AssertJUnit.assertEquals((int)1, (int)this.remoteCache.size());
        this.expectElementsInQueue(listener.createEvents, 1);
        this.remoteCache.removeClientListener((Object)listener);
    }

    private void expectElementsInQueue(BlockingQueue<?> queue, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            try {
                Object e = queue.poll(5L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((String)"Queue was empty!", e);
                continue;
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for condition", e);
            }
        }
        try {
            Object e = queue.poll(5L, TimeUnit.SECONDS);
            AssertJUnit.assertNull((String)"No more elements expected in queue!", e);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while waiting for condition", e);
        }
    }

    @ClientListener
    private static class NoopEventListener {
        public final BlockingQueue<ClientCacheEntryCreatedEvent> createEvents = new LinkedBlockingQueue<ClientCacheEntryCreatedEvent>();

        private NoopEventListener() {
        }

        @ClientCacheEntryCreated
        public void handleCreatedEvent(ClientCacheEntryCreatedEvent<?> e) {
            this.createEvents.add(e);
        }
    }
}

