/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.filter.KeyValueFilterConverterFactory;
import org.infinispan.filter.ParamKeyValueFilterConverterFactory;
import org.infinispan.metadata.Metadata;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseMultiServerRemoteIteratorTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    public static final int CACHE_SIZE = 20;

    @BeforeMethod
    public void clear() {
        this.clients.forEach(c -> c.getCache().clear());
    }

    @Test
    public void testBatchSizes() {
        int maximumBatchSize = 120;
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, this::newAccount, cache);
        Set expectedKeys = this.rangeAsSet(0, 20);
        for (int batch = 1; batch < maximumBatchSize; batch += 10) {
            HashSet results = new HashSet(20);
            CloseableIterator iterator = cache.retrieveEntries(null, null, batch);
            iterator.forEachRemaining(results::add);
            iterator.close();
            AssertJUnit.assertEquals((int)20, (int)results.size());
            AssertJUnit.assertEquals((Object)expectedKeys, (Object)this.extractKeys(results));
        }
    }

    @Test
    public void testEmptyCache() {
        try (CloseableIterator iterator = this.client(0).getCache().retrieveEntries(null, null, 100);){
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
            AssertJUnit.assertFalse((boolean)iterator.hasNext());
        }
    }

    @Test
    public void testFilterBySegmentAndCustomFilter() {
        String toHexConverterName = "toHexConverter";
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory(toHexConverterName, (KeyValueFilterConverterFactory)new ToHexConverterFactory()));
        RemoteCache numbersCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, i -> i, numbersCache);
        Set segments = this.setOf(new Integer[]{15, 20, 25});
        HashSet<Map.Entry> entries = new HashSet<Map.Entry>();
        try (CloseableIterator iterator = numbersCache.retrieveEntries(toHexConverterName, segments, 10);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        Set values = this.extractValues(entries);
        this.getKeysFromSegments(segments).forEach(i -> Assert.assertTrue((boolean)values.contains(Integer.toHexString(i))));
    }

    @Test
    public void testFilterByCustomParamFilter() {
        String factoryName = "substringConverter";
        this.servers.forEach(s -> s.addKeyValueFilterConverterFactory(factoryName, (KeyValueFilterConverterFactory)new SubstringFilterFactory()));
        int filterParam = 12;
        RemoteCache stringCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        IntStream.rangeClosed(0, 19).forEach(idx -> stringCache.put((Object)String.valueOf(idx), (Object)UUID.randomUUID().toString()));
        Set entries = this.extractEntries(stringCache.retrieveEntries(factoryName, new Object[]{filterParam}, null, 10));
        Set values = this.extractValues(entries);
        this.assertForAll(values, s -> s.length() == filterParam);
        entries = this.extractEntries(stringCache.retrieveEntries(factoryName, 10));
        values = this.extractValues(entries);
        this.assertForAll(values, s -> s.length() == 20);
    }

    @Test
    public void testFilterBySegment() {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(20, this::newAccount, cache);
        Set filterBySegments = this.rangeAsSet(30, 40);
        HashSet<Map.Entry> entries = new HashSet<Map.Entry>();
        try (CloseableIterator iterator = cache.retrieveEntries(null, filterBySegments, 10);){
            while (iterator.hasNext()) {
                entries.add((Map.Entry)iterator.next());
            }
        }
        Marshaller marshaller = ((RemoteCacheManager)this.clients.get(0)).getMarshaller();
        KeyPartitioner keyPartitioner = (KeyPartitioner)TestingUtil.extractComponent((Cache)this.cache(0), KeyPartitioner.class);
        this.assertKeysInSegment(entries, filterBySegments, marshaller, arg_0 -> ((KeyPartitioner)keyPartitioner).getSegment(arg_0));
    }

    @Test
    public void testRetrieveMetadata() throws Exception {
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        cache.put((Object)1, (Object)this.newAccount(1), 1L, TimeUnit.DAYS);
        cache.put((Object)2, (Object)this.newAccount(2), 2L, TimeUnit.MINUTES, 30L, TimeUnit.SECONDS);
        cache.put((Object)3, (Object)this.newAccount(3));
        try (CloseableIterator iterator = cache.retrieveEntriesWithMetadata(null, 10);){
            Map.Entry entry = (Map.Entry)iterator.next();
            if ((Integer)entry.getKey() == 1) {
                AssertJUnit.assertEquals((int)86400, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
            if ((Integer)entry.getKey() == 2) {
                AssertJUnit.assertEquals((int)120, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)30, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
            if ((Integer)entry.getKey() == 3) {
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getLifespan());
                AssertJUnit.assertEquals((int)-1, (int)((MetadataValue)entry.getValue()).getMaxIdle());
            }
        }
    }

    private Set<Integer> getKeysFromSegments(Set<Integer> segments) {
        RemoteCacheManager remoteCacheManager = (RemoteCacheManager)this.clients.get(0);
        RemoteCache cache = remoteCacheManager.getCache();
        Marshaller marshaller = ((RemoteCacheManager)this.clients.get(0)).getMarshaller();
        KeyPartitioner keyPartitioner = (KeyPartitioner)TestingUtil.extractComponent((Cache)this.cache(0), KeyPartitioner.class);
        CloseableIteratorSet keys = cache.keySet();
        return keys.stream().filter(b -> segments.contains(keyPartitioner.getSegment((Object)this.toByteBuffer(b, marshaller)))).collect(Collectors.toSet());
    }

    static final class SubstringFilterFactory
    implements ParamKeyValueFilterConverterFactory<String, String, String> {
        public static final int DEFAULT_LENGTH = 20;

        SubstringFilterFactory() {
        }

        public KeyValueFilterConverter<String, String, String> getFilterConverter(Object[] params) {
            return new SubstringFilterConverter(params);
        }

        static class SubstringFilterConverter
        extends AbstractKeyValueFilterConverter<String, String, String>
        implements Serializable {
            private final int length;

            public SubstringFilterConverter(Object[] params) {
                this.length = (Integer)(params == null || params.length == 0 ? Integer.valueOf(20) : params[0]);
            }

            public String filterAndConvert(String key, String value, Metadata metadata) {
                return value.substring(0, this.length);
            }
        }
    }

    static final class ToHexConverterFactory
    implements KeyValueFilterConverterFactory<Integer, Integer, String> {
        ToHexConverterFactory() {
        }

        public KeyValueFilterConverter<Integer, Integer, String> getFilterConverter() {
            return new HexFilterConverter();
        }

        static class HexFilterConverter
        extends AbstractKeyValueFilterConverter<Integer, Integer, String>
        implements Serializable {
            HexFilterConverter() {
            }

            public String filterAndConvert(Integer key, Integer value, Metadata metadata) {
                return Integer.toHexString(value);
            }
        }
    }
}

