/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.util.Collections;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.ClientProtoStreamMarshallerTest", groups={"functional"})
@CleanupAfterMethod
public class ClientProtoStreamMarshallerTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        MarshallerRegistration.registerMarshallers(this.remoteCacheManager);
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() throws Exception {
        User user = this.createUser();
        this.remoteCache.put((Object)1, (Object)user);
        AssertJUnit.assertEquals((int)1, (int)this.cache.keySet().size());
        byte[] key = (byte[])this.cache.keySet().iterator().next();
        Object localObject = this.cache.get((Object)key);
        AssertJUnit.assertNotNull((Object)localObject);
        AssertJUnit.assertTrue((boolean)(localObject instanceof byte[]));
        Object unmarshalledObject = ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)MarshallerUtil.getSerializationContext((RemoteCacheManager)this.remoteCacheManager), (byte[])((byte[])localObject));
        AssertJUnit.assertTrue((boolean)(unmarshalledObject instanceof User));
        this.assertUser((User)unmarshalledObject);
        User fromRemoteCache = (User)this.remoteCache.get((Object)1);
        this.assertUser(fromRemoteCache);
    }

    private User createUser() {
        UserPB user = new UserPB();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        AddressPB address = new AddressPB();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((int)1, (int)user.getId());
        AssertJUnit.assertEquals((String)"Tom", (String)user.getName());
        AssertJUnit.assertEquals((String)"Cat", (String)user.getSurname());
        AssertJUnit.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        AssertJUnit.assertNotNull((Object)user.getAccountIds());
        AssertJUnit.assertEquals((int)1, (int)user.getAccountIds().size());
        AssertJUnit.assertTrue((boolean)user.getAccountIds().contains(12));
        AssertJUnit.assertNotNull((Object)user.getAddresses());
        AssertJUnit.assertEquals((int)1, (int)user.getAddresses().size());
        AssertJUnit.assertEquals((String)"Dark Alley", (String)((Address)user.getAddresses().get(0)).getStreet());
        AssertJUnit.assertEquals((String)"1234", (String)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

