/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.query.testdomain.protobuf.TestEntity;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.BuiltInAnalyzersTest")
public class BuiltInAnalyzersTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @BeforeClass
    protected void registerProtobufSchema() throws Exception {
        String protoFile = Util.getResourceAsString((String)"/analyzers.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"analyzers.proto", (Object)protoFile);
        RemoteQueryTestUtils.checkSchemaErrors((RemoteCache<String, String>)metadataCache);
        SerializationContext serCtx = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"analyzers.proto", (String)protoFile));
        serCtx.registerMarshaller((BaseMarshaller)new TestEntity.TestEntityMarshaller());
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue()).marshaller((Marshaller)new ProtoStreamMarshaller());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Test
    public void testKeywordAnalyzer() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        TestEntity child = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", null);
        TestEntity parent = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", child);
        remoteCache.put((Object)1, (Object)parent);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name4:'name-with-dashes'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity p where p.child.name4:'name-with-dashes'").getResultSize());
    }

    @Test
    public void testShippedAnalyzers() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        TestEntity testEntity = new TestEntity("Sarah-Jane Lee", "John McDougall", "James Connor", "Oswald Lee", "Jason Hawkings", "Gyorgy Constantinides");
        remoteCache.put((Object)1, (Object)testEntity);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name1:'jane'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name2:'McDougall'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name3:'Connor'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name4:'Oswald Lee'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name5:'hawk'").getResultSize());
        AssertJUnit.assertEquals((int)1, (int)queryFactory.create("From TestEntity where name6:'constan'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name1:'sara'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name2:'John McDougal'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name3:'James-Connor'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name4:'Oswald lee'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name5:'json'").getResultSize());
        AssertJUnit.assertEquals((int)0, (int)queryFactory.create("From TestEntity where name6:'Georje'").getResultSize());
    }
}

