/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryProtostreamAnnotationsDisableIndexingTest")
public class RemoteQueryProtostreamAnnotationsDisableIndexingTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createServerModeCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        return new RemoteCacheManager(clientBuilder.build());
    }

    @BeforeClass
    protected void registerProtobufSchema() throws Exception {
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoSchemaFile = protoSchemaBuilder.fileName("memo.proto").addClass(Memo.class).addClass(Author.class).build(serializationContext);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"memo.proto", (Object)protoSchemaFile);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
    }

    public void testAttributeQuery() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.put((Object)1, (Object)this.createMemo1());
        remoteCache.put((Object)2, (Object)this.createMemo2());
        Memo fromCache = (Memo)remoteCache.get((Object)1);
        this.assertMemo1(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache);
        Query query = qf.from(Memo.class).having("text").like("%ipsum%").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo1((Memo)list.get(0));
        query = qf.from(Memo.class).having("author.name").eq((Object)"Adrian").build();
        list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Memo.class, ((Memo)list.get(0)).getClass());
        this.assertMemo2((Memo)list.get(0));
    }

    private Memo createMemo1() {
        Memo memo = new Memo(1, "Lorem ipsum");
        memo.author = new Author(1, "Tom");
        return memo;
    }

    private Memo createMemo2() {
        Memo memo = new Memo(2, "Sed ut perspiciatis unde omnis iste natus error");
        memo.author = new Author(2, "Adrian");
        return memo;
    }

    private void assertMemo1(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)1, (int)memo.id);
        AssertJUnit.assertEquals((String)"Lorem ipsum", (String)memo.text);
        AssertJUnit.assertEquals((int)1, (int)memo.author.id);
    }

    private void assertMemo2(Memo memo) {
        AssertJUnit.assertNotNull((Object)memo);
        AssertJUnit.assertEquals((int)2, (int)memo.id);
        AssertJUnit.assertEquals((String)"Sed ut perspiciatis unde omnis iste natus error", (String)memo.text);
        AssertJUnit.assertEquals((int)2, (int)memo.author.id);
    }

    public static class Author {
        @ProtoField(number=1, required=true)
        public int id;
        @ProtoField(number=2)
        public String name;

        public Author(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Author() {
        }

        public String toString() {
            return "Author{id=" + this.id + ", name='" + this.name + "'}";
        }
    }

    @ProtoDoc(value="@Indexed(false)")
    public static class Memo {
        @ProtoField(number=10, required=true)
        public int id;
        @ProtoField(number=20)
        public String text;
        @ProtoField(number=30)
        public Author author;

        public Memo(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public Memo() {
        }

        public String toString() {
            return "Memo{id=" + this.id + ", text='" + this.text + '\'' + ", author=" + this.author + '}';
        }
    }
}

