/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public abstract class SingleHotRodServerTest
extends SingleCacheManagerTest {
    protected HotRodServer hotrodServer;
    protected RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = this.createHotRodServer();
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCacheManager.getCache();
    }

    protected HotRodServer createHotRodServer() {
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        this.remoteCacheManager = null;
        super.teardown();
    }
}

