/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.client.hotrod.tx.util.TransactionSetup;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.test.Exceptions;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.MultipleCacheTxFunctionalTest")
public class MultipleCacheTxFunctionalTest<K, V>
extends MultiHotRodServersTest {
    private static final String CACHE_A = "tx-cache-a";
    private static final String CACHE_B = "tx-cache-b";
    private static final String CACHE_C = "tx-cache-c";
    private KeyValueGenerator<K, V> kvGenerator;
    private TransactionMode transactionMode;

    public Object[] factory() {
        return new Object[]{super.transactionMode(TransactionMode.NON_XA), super.transactionMode(TransactionMode.NON_XA), super.transactionMode(TransactionMode.NON_XA), super.transactionMode(TransactionMode.NON_DURABLE_XA), super.transactionMode(TransactionMode.NON_DURABLE_XA), super.transactionMode(TransactionMode.NON_DURABLE_XA), super.transactionMode(TransactionMode.FULL_XA), super.transactionMode(TransactionMode.FULL_XA), super.transactionMode(TransactionMode.FULL_XA)};
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        HotRodClientTestingUtil.assertNoTransaction(this.clients);
        super.clearContent();
    }

    public void testMultipleCaches(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        K k2 = this.kvGenerator.generateKey(method, 2);
        K k3 = this.kvGenerator.generateKey(method, 3);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        V v3 = this.kvGenerator.generateValue(method, 3);
        RemoteCache<K, V> remoteCacheA = this.remoteCache(CACHE_A);
        RemoteCache<K, V> remoteCacheB = this.remoteCache(CACHE_B);
        RemoteCache<K, V> remoteCacheC = this.remoteCache(CACHE_C);
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheB.getTransactionManager());
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheC.getTransactionManager());
        TransactionManager tm = remoteCacheA.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCacheA.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCacheB.put(k2, v2));
        this.kvGenerator.assertValueEquals(null, remoteCacheC.put(k3, v3));
        this.kvGenerator.assertValueEquals(v1, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCacheB.get(k2));
        this.kvGenerator.assertValueEquals(v3, remoteCacheC.get(k3));
        tm.commit();
        this.assertEntryInAllClients(CACHE_A, k1, v1);
        this.assertEntryInAllClients(CACHE_A, k2, null);
        this.assertEntryInAllClients(CACHE_A, k3, null);
        this.assertEntryInAllClients(CACHE_B, k1, null);
        this.assertEntryInAllClients(CACHE_B, k2, v2);
        this.assertEntryInAllClients(CACHE_B, k3, null);
        this.assertEntryInAllClients(CACHE_C, k1, null);
        this.assertEntryInAllClients(CACHE_C, k2, null);
        this.assertEntryInAllClients(CACHE_C, k3, v3);
    }

    public void testMultipleCacheWithSameKey(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        V v3 = this.kvGenerator.generateValue(method, 3);
        RemoteCache<K, V> remoteCacheA = this.remoteCache(CACHE_A);
        RemoteCache<K, V> remoteCacheB = this.remoteCache(CACHE_B);
        RemoteCache<K, V> remoteCacheC = this.remoteCache(CACHE_C);
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheB.getTransactionManager());
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheC.getTransactionManager());
        TransactionManager tm = remoteCacheA.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCacheA.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCacheB.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCacheC.put(k1, v3));
        this.kvGenerator.assertValueEquals(v1, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCacheB.get(k1));
        this.kvGenerator.assertValueEquals(v3, remoteCacheC.get(k1));
        tm.commit();
        this.assertEntryInAllClients(CACHE_A, k1, v1);
        this.assertEntryInAllClients(CACHE_B, k1, v2);
        this.assertEntryInAllClients(CACHE_C, k1, v3);
    }

    public void testMultipleCacheWithConflict(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        V v3 = this.kvGenerator.generateValue(method, 3);
        V v4 = this.kvGenerator.generateValue(method, 4);
        RemoteCache<K, V> remoteCacheA = this.remoteCache(CACHE_A);
        RemoteCache<K, V> remoteCacheB = this.remoteCache(CACHE_B);
        RemoteCache<K, V> remoteCacheC = this.remoteCache(CACHE_C);
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheB.getTransactionManager());
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheC.getTransactionManager());
        TransactionManager tm = remoteCacheA.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(null, remoteCacheA.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCacheB.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCacheC.put(k1, v3));
        this.kvGenerator.assertValueEquals(v1, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCacheB.get(k1));
        this.kvGenerator.assertValueEquals(v3, remoteCacheC.get(k1));
        Transaction tx = tm.suspend();
        this.client(0).getCache(CACHE_A).put(k1, v4);
        tm.resume(tx);
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(CACHE_A, k1, v4);
        this.assertEntryInAllClients(CACHE_B, k1, null);
        this.assertEntryInAllClients(CACHE_C, k1, null);
    }

    public void testMultipleCacheRollback(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        V v3 = this.kvGenerator.generateValue(method, 3);
        RemoteCache<K, V> remoteCacheA = this.remoteCache(CACHE_A);
        RemoteCache<K, V> remoteCacheB = this.remoteCache(CACHE_B);
        RemoteCache<K, V> remoteCacheC = this.remoteCache(CACHE_C);
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheB.getTransactionManager());
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheC.getTransactionManager());
        TransactionManager tm = remoteCacheA.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCacheA.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCacheB.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCacheC.put(k1, v3));
        this.kvGenerator.assertValueEquals(v1, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCacheB.get(k1));
        this.kvGenerator.assertValueEquals(v3, remoteCacheC.get(k1));
        tm.rollback();
        this.assertEntryInAllClients(CACHE_A, k1, null);
        this.assertEntryInAllClients(CACHE_B, k1, null);
        this.assertEntryInAllClients(CACHE_C, k1, null);
    }

    public void testMultipleCacheSetRollbackOnly(Method method) throws Exception {
        K k1 = this.kvGenerator.generateKey(method, 1);
        V v1 = this.kvGenerator.generateValue(method, 1);
        V v2 = this.kvGenerator.generateValue(method, 2);
        V v3 = this.kvGenerator.generateValue(method, 3);
        RemoteCache<K, V> remoteCacheA = this.remoteCache(CACHE_A);
        RemoteCache<K, V> remoteCacheB = this.remoteCache(CACHE_B);
        RemoteCache<K, V> remoteCacheC = this.remoteCache(CACHE_C);
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheB.getTransactionManager());
        AssertJUnit.assertSame((Object)remoteCacheA.getTransactionManager(), (Object)remoteCacheC.getTransactionManager());
        TransactionManager tm = remoteCacheA.getTransactionManager();
        tm.begin();
        this.kvGenerator.assertValueEquals(null, remoteCacheA.put(k1, v1));
        this.kvGenerator.assertValueEquals(null, remoteCacheB.put(k1, v2));
        this.kvGenerator.assertValueEquals(null, remoteCacheC.put(k1, v3));
        this.kvGenerator.assertValueEquals(v1, remoteCacheA.get(k1));
        this.kvGenerator.assertValueEquals(v2, remoteCacheB.get(k1));
        this.kvGenerator.assertValueEquals(v3, remoteCacheC.get(k1));
        tm.setRollbackOnly();
        Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        this.assertEntryInAllClients(CACHE_A, k1, null);
        this.assertEntryInAllClients(CACHE_B, k1, null);
        this.assertEntryInAllClients(CACHE_C, k1, null);
    }

    @BeforeClass(alwaysRun=true)
    public void printParameters() {
        this.log.debugf("Parameters: %s", (Object)super.parameters());
    }

    protected String[] parameterNames() {
        return (String[])MultipleCacheTxFunctionalTest.concat((Object[])super.parameterNames(), (Object[])new String[]{null, null});
    }

    protected Object[] parameterValues() {
        return MultipleCacheTxFunctionalTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.kvGenerator.toString(), this.transactionMode});
    }

    protected String parameters() {
        return "[" + this.kvGenerator + "/" + this.transactionMode + "]";
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = MultipleCacheTxFunctionalTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cacheBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createHotRodServers(3, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_A, cacheBuilder);
        this.defineInAll(CACHE_B, cacheBuilder);
        this.defineInAll(CACHE_C, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        clientBuilder.forceReturnValues(false);
        TransactionSetup.amendJTA(clientBuilder);
        clientBuilder.transaction().transactionMode(this.transactionMode);
        return clientBuilder;
    }

    private RemoteCache<K, V> remoteCache(String cacheName) {
        return this.client(0).getCache(cacheName);
    }

    private void assertEntryInAllClients(String cacheName, K key, V value) {
        for (RemoteCacheManager manager : this.clients) {
            RemoteCache remoteCache = manager.getCache(cacheName);
            this.kvGenerator.assertValueEquals(value, remoteCache.get(key));
        }
    }

    private MultipleCacheTxFunctionalTest<K, V> keyValueGenerator(KeyValueGenerator<K, V> kvGenerator) {
        this.kvGenerator = kvGenerator;
        return this;
    }

    private MultipleCacheTxFunctionalTest<K, V> transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }
}

