/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.infinispan.client.hotrod.configuration.AbstractSecurityConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SaslQop;
import org.infinispan.client.hotrod.configuration.SaslStrength;
import org.infinispan.client.hotrod.configuration.SecurityConfigurationBuilder;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.security.BasicCallbackHandler;
import org.infinispan.client.hotrod.security.VoidCallbackHandler;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class AuthenticationConfigurationBuilder
extends AbstractSecurityConfigurationChildBuilder
implements Builder<AuthenticationConfiguration> {
    public static final String DEFAULT_REALM = "ApplicationRealm";
    private CallbackHandler callbackHandler;
    private boolean enabled = false;
    private String serverName;
    private Map<String, String> saslProperties = new HashMap<String, String>();
    private String saslMechanism;
    private Subject clientSubject;
    private String username;
    private char[] password;
    private String realm;

    public AuthenticationConfigurationBuilder(SecurityConfigurationBuilder builder) {
        super(builder);
    }

    public AuthenticationConfigurationBuilder callbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        return this;
    }

    public AuthenticationConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AuthenticationConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public AuthenticationConfigurationBuilder disable() {
        this.enabled = false;
        return this;
    }

    public AuthenticationConfigurationBuilder saslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslProperties(Map<String, String> saslProperties) {
        this.saslProperties = saslProperties;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslQop(SaslQop ... qop) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < qop.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(qop[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.qop", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder saslStrength(SaslStrength ... strength) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strength.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(strength[i].toString());
        }
        this.saslProperties.put("javax.security.sasl.strength", s.toString());
        return this.enable();
    }

    public AuthenticationConfigurationBuilder serverName(String serverName) {
        this.serverName = serverName;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder clientSubject(Subject clientSubject) {
        this.clientSubject = clientSubject;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder username(String username) {
        this.username = username;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(String password) {
        this.password = password != null ? password.toCharArray() : null;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder password(char[] password) {
        this.password = password;
        return this.enable();
    }

    public AuthenticationConfigurationBuilder realm(String realm) {
        this.realm = realm;
        return this.enable();
    }

    public AuthenticationConfiguration create() {
        String mech;
        String string = mech = this.saslMechanism == null ? "DIGEST-MD5" : this.saslMechanism;
        CallbackHandler cbh = this.username != null ? new BasicCallbackHandler(this.username, this.realm != null ? this.realm : DEFAULT_REALM, this.password) : ("EXTERNAL".equals(mech) && this.callbackHandler == null ? new VoidCallbackHandler() : this.callbackHandler);
        return new AuthenticationConfiguration(cbh, this.clientSubject, this.enabled, mech, this.saslProperties, this.serverName);
    }

    public Builder<?> read(AuthenticationConfiguration template) {
        this.callbackHandler = template.callbackHandler();
        this.clientSubject = template.clientSubject();
        this.enabled = template.enabled();
        this.saslMechanism = template.saslMechanism();
        this.saslProperties = template.saslProperties();
        this.serverName = template.serverName();
        return this;
    }

    public void validate() {
        if (this.enabled) {
            if (this.callbackHandler == null && this.clientSubject == null && this.username == null && !"EXTERNAL".equals(this.saslMechanism)) {
                throw Log.HOTROD.invalidCallbackHandler();
            }
            if (this.callbackHandler != null && this.username != null) {
                throw Log.HOTROD.callbackHandlerAndUsernameMutuallyExclusive();
            }
        }
    }

    @Override
    public ConfigurationBuilder withProperties(Properties properties) {
        Map<String, String> saslProperties;
        Object prop;
        TypedProperties typed = TypedProperties.toTypedProperties((Properties)properties);
        if (typed.containsKey((Object)"infinispan.client.hotrod.sasl_mechanism")) {
            this.saslMechanism(typed.getProperty("infinispan.client.hotrod.sasl_mechanism", this.saslMechanism, true));
        }
        if ((prop = typed.get((Object)"infinispan.client.hotrod.auth_callback_handler")) instanceof String) {
            String cbhClassName = StringPropertyReplacer.replaceProperties((String)((String)prop));
            CallbackHandler handler = (CallbackHandler)Util.getInstance((String)cbhClassName, (ClassLoader)this.builder.getBuilder().classLoader());
            this.callbackHandler(handler);
        } else if (prop instanceof CallbackHandler) {
            this.callbackHandler((CallbackHandler)prop);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.auth_username")) {
            this.username(typed.getProperty("infinispan.client.hotrod.auth_username", this.username, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.auth_password")) {
            this.password(typed.getProperty("infinispan.client.hotrod.auth_password", null, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.auth_realm")) {
            this.realm(typed.getProperty("infinispan.client.hotrod.auth_realm", this.realm, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.auth_server_name")) {
            this.serverName(typed.getProperty("infinispan.client.hotrod.auth_server_name", this.serverName, true));
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.auth_client_subject")) {
            this.clientSubject((Subject)typed.get((Object)"infinispan.client.hotrod.auth_client_subject"));
        }
        if (!(saslProperties = typed.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("infinispan.client.hotrod.sasl_properties")).collect(Collectors.toMap(e -> ConfigurationProperties.SASL_PROPERTIES_PREFIX_REGEX.matcher((String)e.getKey()).replaceFirst(""), e -> StringPropertyReplacer.replaceProperties((String)((String)e.getValue()))))).isEmpty()) {
            this.saslProperties(saslProperties);
        }
        if (typed.containsKey((Object)"infinispan.client.hotrod.use_auth")) {
            this.enabled(typed.getBooleanProperty("infinispan.client.hotrod.use_auth", this.enabled, true));
        }
        return this.builder.getBuilder();
    }
}

