/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.transaction.TransactionOperationFactory;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.operations.CompleteTransactionOperation;
import org.infinispan.client.hotrod.impl.transaction.operations.ForgetTransactionOperation;
import org.infinispan.client.hotrod.logging.Log;

abstract class AbstractTransactionTable
implements TransactionTable {
    private final long timeout;
    private volatile TransactionOperationFactory operationFactory;

    AbstractTransactionTable(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public final void start(TransactionOperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    TransactionOperationFactory assertStartedAndReturnFactory() {
        TransactionOperationFactory tmp = this.operationFactory;
        if (tmp == null) {
            throw this.getLog().transactionTableNotStarted();
        }
        return tmp;
    }

    abstract Log getLog();

    abstract boolean isTraceLogEnabled();

    final long getTimeout() {
        return this.timeout;
    }

    int completeTransaction(Xid xid, boolean commit) {
        try {
            TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
            CompleteTransactionOperation operation = factory.newCompleteTransactionOperation(xid, commit);
            return (Integer)operation.execute().get();
        }
        catch (Exception e) {
            this.getLog().debug("Exception while commit/rollback.", e);
            return 6;
        }
    }

    void forgetTransaction(Xid xid) {
        block2: {
            try {
                TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
                ForgetTransactionOperation operation = factory.newForgetTransactionOperation(xid);
                operation.execute();
            }
            catch (Exception e) {
                if (!this.isTraceLogEnabled()) break block2;
                this.getLog().tracef(e, "Exception in forget transaction xid=%s", xid);
            }
        }
    }

    CompletableFuture<Collection<Xid>> fetchPreparedTransactions() {
        try {
            TransactionOperationFactory factory = this.assertStartedAndReturnFactory();
            return factory.newRecoveryOperation().execute();
        }
        catch (Exception e) {
            if (this.isTraceLogEnabled()) {
                this.getLog().trace("Exception while fetching prepared transactions", e);
            }
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }
}

