/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseGetAllTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;

    protected abstract int numberOfHotRodServers();

    protected abstract org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig();

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    protected Set<Integer> populateCacheManager() {
        HashMap<Integer, Integer> entries = new HashMap<Integer, Integer>();
        for (int i = 0; i < 100; ++i) {
            entries.put(i, i);
        }
        this.remoteCache.putAll(entries);
        return entries.keySet();
    }

    public void testBulkGetKeys() {
        Set<Integer> keys = this.populateCacheManager();
        Map map = this.remoteCache.getAll(keys);
        AssertJUnit.assertEquals((int)100, (int)map.size());
        for (int i = 0; i < 100; ++i) {
            AssertJUnit.assertEquals((Object)i, map.get(i));
        }
    }

    public void testBulkGetAfterLifespanExpire() throws InterruptedException {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long startTime = System.currentTimeMillis();
        long lifespan = 10000L;
        this.remoteCache.putAll(dataIn, 10000L, TimeUnit.MILLISECONDS);
        Map dataOut = new HashMap();
        while (true) {
            dataOut = this.remoteCache.getAll(dataIn.keySet());
            if (System.currentTimeMillis() >= startTime + 10000L) break;
            AssertJUnit.assertEquals((int)dataOut.size(), (int)dataIn.size());
            for (Map.Entry outEntry : dataOut.entrySet()) {
                AssertJUnit.assertEquals(dataIn.get(outEntry.getKey()), outEntry.getValue());
            }
            Thread.sleep(100L);
        }
        int size = dataOut.size();
        while (System.currentTimeMillis() < startTime + 10000L + 30000L && (size = (dataOut = this.remoteCache.getAll(dataIn.keySet())).size()) != 0) {
        }
        AssertJUnit.assertEquals((String)"There shouldn't be any values left!", (int)0, (int)size);
    }
}

