/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.DroppedConnectionsTest", groups={"functional"})
public class DroppedConnectionsTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false)));
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        return this.cacheManager;
    }

    @AfterClass
    protected void teardown() {
        super.teardown();
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClosedConnection() throws Exception {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.connectionPool().minIdle(1).maxActive(2).addServer().host(this.hotRodServer.getHost()).port(this.hotRodServer.getPort().intValue());
        InternalRemoteCacheManager remoteCacheManager = null;
        try {
            remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
            RemoteCache rc = remoteCacheManager.getCache();
            ChannelFactory channelFactory = remoteCacheManager.getChannelFactory();
            rc.put((Object)"k", (Object)"v");
            InetSocketAddress address = InetSocketAddress.createUnresolved("127.0.0.1", this.hotRodServer.getPort());
            AssertJUnit.assertEquals((int)0, (int)channelFactory.getNumActive((SocketAddress)address));
            AssertJUnit.assertEquals((int)1, (int)channelFactory.getNumIdle((SocketAddress)address));
            Channel channel = (Channel)((NoopChannelOperation)channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).join();
            channelFactory.releaseChannel(channel);
            channel.close().sync();
            AssertJUnit.assertEquals((String)"v", (String)((String)rc.get((Object)"k")));
            AssertJUnit.assertEquals((int)0, (int)channelFactory.getNumActive((SocketAddress)address));
            AssertJUnit.assertEquals((int)1, (int)channelFactory.getNumIdle((SocketAddress)address));
            Channel channel2 = (Channel)((NoopChannelOperation)channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).join();
            AssertJUnit.assertNotSame((Object)channel.id(), (Object)channel2.id());
        }
        catch (Throwable throwable) {
            HotRodClientTestingUtil.killRemoteCacheManager(remoteCacheManager);
            throw throwable;
        }
        HotRodClientTestingUtil.killRemoteCacheManager(remoteCacheManager);
    }
}

