/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodClientJmxTest")
public class HotRodClientJmxTest
extends AbstractInfinispanTest {
    private static final String JMX_DOMAIN = HotRodClientJmxTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private HotRodServer hotrodServer;
    private CacheContainer cacheContainer;
    private RemoteCacheManager rcm;
    private RemoteCache<String, String> remoteCache;

    @BeforeMethod
    void setup() {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        cfg.statistics().enable();
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalCfg, (String)JMX_DOMAIN, (MBeanServerLookup)this.mBeanServerLookup);
        this.cacheContainer = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg, (org.infinispan.configuration.cache.ConfigurationBuilder)cfg);
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheContainer);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        clientBuilder.statistics().enable().jmxEnable().jmxDomain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        this.rcm = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.rcm.getCache();
    }

    @AfterMethod
    void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheContainer});
        HotRodClientTestingUtil.killRemoteCacheManager(this.rcm);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testRemoteCacheManagerMBean() throws Exception {
        MBeanServer mbeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName objectName = HotRodClientTestingUtil.remoteCacheManagerObjectName(this.rcm);
        String[] servers = (String[])mbeanServer.getAttribute(objectName, "Servers");
        AssertJUnit.assertEquals((int)1, (int)servers.length);
        AssertJUnit.assertEquals((String)("localhost:" + this.hotrodServer.getPort()), (String)servers[0]);
        AssertJUnit.assertEquals((Object)1, (Object)mbeanServer.getAttribute(objectName, "ConnectionCount"));
        AssertJUnit.assertEquals((Object)1, (Object)mbeanServer.getAttribute(objectName, "IdleConnectionCount"));
        AssertJUnit.assertEquals((Object)0, (Object)mbeanServer.getAttribute(objectName, "ActiveConnectionCount"));
    }

    public void testRemoteCacheMBean() throws Exception {
        MBeanServer mbeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName objectName = HotRodClientTestingUtil.remoteCacheObjectName(this.rcm, "org.infinispan.default");
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "AverageRemoteReadTime"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "AverageRemoteStoreTime"));
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteMisses"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        this.remoteCache.put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertEquals((String)"a", (String)((String)this.remoteCache.get((Object)"a")));
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        this.remoteCache.putIfAbsent((Object)"a", (Object)"a1");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)"b", (Object)"b"));
        AssertJUnit.assertEquals((Object)2L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertFalse((boolean)this.remoteCache.replace((Object)"b", (Object)"a", (Object)"c"));
        AssertJUnit.assertEquals((Object)2L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertTrue((boolean)this.remoteCache.replace((Object)"b", (Object)"b", (Object)"c"));
        AssertJUnit.assertEquals((Object)3L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertEquals((long)2L, (long)this.remoteCache.entrySet().stream().count());
        AssertJUnit.assertEquals((Object)3L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("c", "c");
        map.put("d", "d");
        this.remoteCache.putAll(map);
        AssertJUnit.assertEquals((Object)5L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        HashSet<String> set = new HashSet<String>(3);
        set.add("a");
        set.add("c");
        set.add("e");
        this.remoteCache.getAll(set);
        AssertJUnit.assertEquals((Object)5L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        AssertJUnit.assertEquals((Object)2L, (Object)mbeanServer.getAttribute(objectName, "RemoteMisses"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "RemoteRemoves"));
        this.remoteCache.remove((Object)"b");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteRemoves"));
        OutputStream os = this.remoteCache.streaming().put((Object)"s");
        os.write(115);
        os.close();
        AssertJUnit.assertEquals((Object)6L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        InputStream is = this.remoteCache.streaming().get((Object)"s");
        while (is.read() >= 0) {
        }
        is.close();
        AssertJUnit.assertEquals((Object)6L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        AssertJUnit.assertNull((Object)this.remoteCache.streaming().get((Object)"t"));
        AssertJUnit.assertEquals((Object)6L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
    }
}

