/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.invoke.MethodHandles;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodClientNearCacheJmxTest")
public class HotRodClientNearCacheJmxTest
extends AbstractInfinispanTest {
    private HotRodServer hotrodServer;
    private CacheContainer cacheContainer;
    private RemoteCacheManager[] rcms;
    private RemoteCache<String, String>[] remoteCaches;
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @BeforeMethod
    protected void setup() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        cfg.statistics().enable();
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalCfg, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        this.cacheContainer = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg, (org.infinispan.configuration.cache.ConfigurationBuilder)cfg);
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheContainer);
        this.rcms = new RemoteCacheManager[2];
        this.remoteCaches = new RemoteCache[2];
        for (int i = 0; i < 2; ++i) {
            ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
            clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
            clientBuilder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(100);
            clientBuilder.statistics().enable().jmxEnable().jmxDomain(MethodHandles.lookup().lookupClass().getSimpleName() + i).mBeanServerLookup(this.mBeanServerLookup);
            this.rcms[i] = new RemoteCacheManager(clientBuilder.build());
            this.remoteCaches[i] = this.rcms[i].getCache();
        }
    }

    @AfterMethod
    void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheContainer});
        for (int i = 0; i < 2; ++i) {
            HotRodClientTestingUtil.killRemoteCacheManager(this.rcms[i]);
        }
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testNearRemoteCacheMBean() throws Exception {
        MBeanServer mbeanServer = this.mBeanServerLookup.getMBeanServer();
        ObjectName objectName = HotRodClientTestingUtil.remoteCacheObjectName(this.rcms[0], "org.infinispan.default");
        this.remoteCaches[0].get((Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteMisses"));
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "NearCacheMisses"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "NearCacheSize"));
        this.remoteCaches[0].put((Object)"a", (Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteStores"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "NearCacheSize"));
        this.remoteCaches[0].get((Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        AssertJUnit.assertEquals((Object)2L, (Object)mbeanServer.getAttribute(objectName, "NearCacheMisses"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "NearCacheHits"));
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "NearCacheSize"));
        this.remoteCaches[0].get((Object)"a");
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "RemoteHits"));
        AssertJUnit.assertEquals((Object)2L, (Object)mbeanServer.getAttribute(objectName, "NearCacheMisses"));
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "NearCacheHits"));
        AssertJUnit.assertEquals((Object)1L, (Object)mbeanServer.getAttribute(objectName, "NearCacheSize"));
        AssertJUnit.assertEquals((Object)0L, (Object)mbeanServer.getAttribute(objectName, "NearCacheInvalidations"));
        this.remoteCaches[1].put((Object)"a", (Object)"b");
        this.eventually(() -> (Long)mbeanServer.getAttribute(objectName, "NearCacheInvalidations") == 1L, 1000L);
    }
}

