/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.util.Collections;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ProtobufJsonScriptTest")
public class ProtobufJsonScriptTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_NAME = "protobuf-json-script.js";
    private static final int CLUSTER_SIZE = 2;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ProtobufJsonScriptTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.encoding().key().mediaType("application/x-protostream");
        cfgBuilder.encoding().value().mediaType("application/x-protostream");
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @Test
    public void testDataAsJSONFromScript() throws IOException {
        RemoteCacheManager remoteCacheManager = this.client(0);
        RemoteCache cache = remoteCacheManager.getCache();
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAge(33);
        user1.setAccountIds(Collections.singleton(12));
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Jane");
        user2.setSurname("Doe");
        user2.setGender(User.Gender.FEMALE);
        user2.setAge(39);
        cache.put((Object)1, (Object)user1);
        cache.put((Object)2, (Object)user2);
        Query q = Search.getQueryFactory((RemoteCache)cache).create("From sample_bank_account.User where name = 'Jane'");
        User user = (User)q.list().iterator().next();
        Assert.assertEquals((String)"Jane", (String)user.getName());
        this.registerScript(remoteCacheManager, SCRIPT_NAME);
        User result = (User)cache.execute(SCRIPT_NAME, Collections.emptyMap());
        Assert.assertEquals((int)result.getId(), (int)3);
        Assert.assertEquals((String)result.getName(), (String)"Rex");
        Assert.assertEquals((int)result.getAge(), (int)67);
    }

    private void registerScript(RemoteCacheManager remoteCacheManager, String script) throws IOException {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        String string = Util.getResourceAsString((String)("/" + script), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        scriptCache.put((Object)SCRIPT_NAME, (Object)string);
    }
}

