/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SkipNotificationsFlagTest", groups={"functional"})
@CleanupAfterTest
public class SkipNotificationsFlagTest
extends SingleCacheManagerTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private FlagCheckCommandInterceptor commandInterceptor;
    private RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotRodServer;

    public void testPut() {
        this.performTest(RequestType.PUT);
    }

    public void testReplace() {
        this.performTest(RequestType.REPLACE);
    }

    public void testPutIfAbsent() {
        this.performTest(RequestType.PUT_IF_ABSENT);
    }

    public void testReplaceIfUnmodified() {
        this.performTest(RequestType.REPLACE_IF_UNMODIFIED);
    }

    public void testRemove() {
        this.performTest(RequestType.REMOVE);
    }

    public void testRemoveIfUnmodified() {
        this.performTest(RequestType.REMOVE_IF_UNMODIFIED);
    }

    public void testPutAll() {
        this.performTest(RequestType.PUT_ALL);
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        Properties hotRodClientConf = new Properties();
        hotRodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        super.teardown();
    }

    private void performTest(RequestType type) {
        this.commandInterceptor.expectSkipIndexingFlag = true;
        type.execute((RemoteCache<String, String>)this.remoteCache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}));
    }

    @BeforeClass(alwaysRun=true)
    private void injectCommandInterceptor() {
        if (this.remoteCache == null) {
            return;
        }
        this.commandInterceptor = new FlagCheckCommandInterceptor();
        TestingUtil.extractInterceptorChain((Cache)this.cache).addInterceptor((AsyncInterceptor)this.commandInterceptor, 1);
    }

    @AfterClass(alwaysRun=true)
    private void resetCommandInterceptor() {
        if (this.commandInterceptor != null) {
            this.commandInterceptor.expectSkipIndexingFlag = false;
        }
    }

    static class FlagCheckCommandInterceptor
    extends BaseAsyncInterceptor {
        private volatile boolean expectSkipIndexingFlag;

        FlagCheckCommandInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) {
            if (command instanceof FlagAffectedCommand) {
                boolean hasFlag = ((FlagAffectedCommand)command).hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION);
                if (this.expectSkipIndexingFlag && !hasFlag) {
                    throw new CacheException("SKIP_LISTENER_NOTIFICATION flag is expected!");
                }
                if (!this.expectSkipIndexingFlag && hasFlag) {
                    throw new CacheException("SKIP_LISTENER_NOTIFICATION flag is *not* expected!");
                }
            }
            return this.invokeNext(ctx, command);
        }
    }

    private static enum RequestType {
        PUT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.put((Object)SkipNotificationsFlagTest.KEY, (Object)SkipNotificationsFlagTest.VALUE);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replace((Object)SkipNotificationsFlagTest.KEY, (Object)SkipNotificationsFlagTest.VALUE);
            }
        }
        ,
        PUT_IF_ABSENT{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.putIfAbsent((Object)SkipNotificationsFlagTest.KEY, (Object)SkipNotificationsFlagTest.VALUE);
            }
        }
        ,
        REPLACE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.replaceWithVersion((Object)SkipNotificationsFlagTest.KEY, (Object)SkipNotificationsFlagTest.VALUE, 0L);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.remove((Object)SkipNotificationsFlagTest.KEY);
            }
        }
        ,
        REMOVE_IF_UNMODIFIED{

            @Override
            void execute(RemoteCache<String, String> cache) {
                cache.removeWithVersion((Object)SkipNotificationsFlagTest.KEY, 0L);
            }
        }
        ,
        PUT_ALL{

            @Override
            void execute(RemoteCache<String, String> cache) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put(SkipNotificationsFlagTest.KEY, SkipNotificationsFlagTest.VALUE);
                cache.putAll(data);
            }
        };


        abstract void execute(RemoteCache<String, String> var1);
    }
}

