/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.admin;

import java.io.File;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.admin.RemoteCacheCreateOnAccessTest")
public class RemoteCacheCreateOnAccessTest
extends MultiHotRodServersTest {
    char serverId;
    boolean clear = true;

    protected void createCacheManagers() throws Throwable {
        this.serverId = (char)65;
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)RemoteCacheCreateOnAccessTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.createHotRodServers(2, builder);
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        char c = this.serverId;
        this.serverId = (char)(c + '\u0001');
        return this.addStatefulHotRodServer(builder, c);
    }

    protected boolean isShared() {
        return false;
    }

    protected HotRodServer addStatefulHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder, char id) {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{((Object)((Object)this)).getClass().getSimpleName() + File.separator + id});
        if (this.clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        gcb.globalState().enable().persistentLocation(stateDirectory).configurationStorage(ConfigurationStorage.OVERLAY);
        if (this.isShared()) {
            String sharedDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{((Object)((Object)this)).getClass().getSimpleName() + File.separator + "COMMON"});
            gcb.globalState().sharedPersistentLocation(sharedDirectory);
        } else {
            gcb.globalState().sharedPersistentLocation(stateDirectory);
        }
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(gcb, builder);
        cm.defineConfiguration("template", builder.build());
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        HotRodServer server = HotRodClientTestingUtil.startHotRodServer(cm, serverBuilder);
        this.servers.add(server);
        return server;
    }

    public void createOnAccessTemplateProgrammatic() throws Throwable {
        String cacheName = "cache-from-template-programmatic";
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server(0).getHost()).port(this.server(0).getPort().intValue()).socketTimeout(3000).remoteCache(cacheName).templateName("template");
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            RemoteCache cache = remoteCacheManager.getCache(cacheName);
            cache.put((Object)"a", (Object)"a");
        }
    }

    public void createOnAccessTemplateDeclarative() throws Throwable {
        String cacheName = "cache-from-template-declarative";
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.socket_timeout", "3000");
        properties.put("infinispan.client.hotrod.cache." + cacheName + ".template_name", "template");
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server(0).getHost()).port(this.server(0).getPort().intValue()).withProperties(properties);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            RemoteCache cache = remoteCacheManager.getCache(cacheName);
            cache.put((Object)"a", (Object)"a");
        }
    }

    public void createOnAccessConfigurationProgrammatic() throws Throwable {
        String cacheName = "cache-from-config-declarative";
        String xml = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", cacheName);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server(0).getHost()).port(this.server(0).getPort().intValue()).socketTimeout(3000).remoteCache(cacheName).configuration(xml);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            RemoteCache cache = remoteCacheManager.getCache(cacheName);
            cache.put((Object)"a", (Object)"a");
        }
    }

    public void createOnAccessConfigurationDeclarative() throws Throwable {
        String cacheName = "cache-from-config-programmatic";
        String xml = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", cacheName);
        Properties properties = new Properties();
        properties.put("infinispan.client.hotrod.socket_timeout", "3000");
        properties.put("infinispan.client.hotrod.cache." + cacheName + ".configuration", xml);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server(0).getHost()).port(this.server(0).getPort().intValue()).withProperties(properties);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            RemoteCache cache = remoteCacheManager.getCache(cacheName);
            cache.put((Object)"a", (Object)"a");
        }
    }

    public void createOnAccessConfigurationProgrammaticAfterConstruction() throws Throwable {
        String cacheName = "cache-from-config-declarative";
        String xml = String.format("<infinispan><cache-container><distributed-cache name=\"%s\"/></cache-container></infinispan>", cacheName);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.server(0).getHost()).port(this.server(0).getPort().intValue()).socketTimeout(3000);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            remoteCacheManager.getConfiguration().addRemoteCache(cacheName, c -> c.configuration(xml));
            RemoteCache cache = remoteCacheManager.getCache(cacheName);
            cache.put((Object)"a", (Object)"a");
        }
    }
}

