/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Person;
import org.infinispan.util.KeyValuePair;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.EagerKeyValueConverterTest")
public class EagerKeyValueConverterTest
extends SingleHotRodServerTest {
    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    public void testWriteMap() throws InterruptedException {
        LinkedBlockingQueue<KeyValuePair<String, Person>> eventsQueue = new LinkedBlockingQueue<KeyValuePair<String, Person>>();
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.addClientListener((Object)new EventListener(eventsQueue, cache.getDataFormat()));
        HashMap<String, Person> data = new HashMap<String, Person>();
        data.put("1", new Person("John"));
        data.put("2", new Person("Mary"));
        data.put("3", new Person("George"));
        cache.putAll(data);
        KeyValuePair event = (KeyValuePair)eventsQueue.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)event);
    }

    @ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
    static class EventListener {
        private final Queue<KeyValuePair<String, Person>> eventsQueue;
        private final DataFormat dataFormat;

        EventListener(Queue<KeyValuePair<String, Person>> eventsQueue, DataFormat dataFormat) {
            this.eventsQueue = eventsQueue;
            this.dataFormat = dataFormat;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        public void handleCreatedModifiedEvent(ClientCacheEntryCustomEvent<byte[]> event) {
            this.eventsQueue.add(this.readEvent(event));
        }

        private KeyValuePair<String, Person> readEvent(ClientCacheEntryCustomEvent<byte[]> event) {
            byte[] eventData = (byte[])event.getEventData();
            ByteBuffer rawData = ByteBuffer.wrap(eventData);
            byte[] rawKey = this.readElement(rawData);
            byte[] rawValue = this.readElement(rawData);
            return new KeyValuePair((Object)((String)this.dataFormat.keyToObj(rawKey, null)), (Object)((Person)this.dataFormat.valueToObj(rawValue, null)));
        }

        private byte[] readElement(ByteBuffer buffer) {
            int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
            byte[] element = new byte[length];
            buffer.get(element);
            return element;
        }
    }
}

