/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.KeyValuePair;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.JsonKeyValueRawEventsTest")
public class JsonKeyValueRawEventsTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().key().mediaType("application/x-protostream");
        builder.encoding().value().mediaType("application/x-protostream");
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)this.contextInitializer(), (ConfigurationBuilder)builder);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    public void testReceiveKeyValuesAsJson() throws InterruptedException {
        LinkedBlockingQueue<KeyValuePair<String, String>> eventsQueue = new LinkedBlockingQueue<KeyValuePair<String, String>>();
        DataFormat jsonValues = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        RemoteCache cache = this.remoteCacheManager.getCache();
        RemoteCache jsonCache = cache.withDataFormat(jsonValues);
        jsonCache.addClientListener((Object)new EventListener(eventsQueue, jsonCache.getDataFormat()));
        cache.put((Object)"1", (Object)new Person("John"));
        KeyValuePair event = (KeyValuePair)eventsQueue.poll(5L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)event);
        Assert.assertEquals((String)((String)event.getKey()), (String)"1");
        Assert.assertEquals((String)((String)event.getValue()), (String)"\n{\n   \"_type\": \"org.infinispan.test.core.Person\",\n   \"name\": \"John\"\n}\n");
    }

    @ClientListener(converterFactoryName="___eager-key-value-version-converter", useRawData=true)
    static class EventListener {
        private final Queue<KeyValuePair<String, String>> eventsQueue;
        private final DataFormat dataFormat;

        EventListener(Queue<KeyValuePair<String, String>> eventsQueue, DataFormat dataFormat) {
            this.eventsQueue = eventsQueue;
            this.dataFormat = dataFormat;
        }

        @ClientCacheEntryCreated
        @ClientCacheEntryModified
        public void handleCreatedModifiedEvent(ClientCacheEntryCustomEvent<byte[]> event) {
            this.eventsQueue.add(this.readEvent(event));
        }

        private KeyValuePair<String, String> readEvent(ClientCacheEntryCustomEvent<byte[]> event) {
            byte[] eventData = (byte[])event.getEventData();
            ByteBuffer rawData = ByteBuffer.wrap(eventData);
            byte[] rawKey = this.readElement(rawData);
            byte[] rawValue = this.readElement(rawData);
            return new KeyValuePair((Object)((String)this.dataFormat.keyToObj(rawKey, null)), (Object)((String)this.dataFormat.valueToObj(rawValue, null)));
        }

        private byte[] readElement(ByteBuffer buffer) {
            int length = UnsignedNumeric.readUnsignedInt((ByteBuffer)buffer);
            byte[] element = new byte[length];
            buffer.get(element);
            return element;
        }
    }
}

