/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.near.InvalidatedNearCacheTest")
public class InvalidatedNearCacheTest
extends SingleHotRodServerTest {
    private StorageType storageType;
    private AssertsNearCache<Integer, String> assertClient;

    private InvalidatedNearCacheTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new InvalidatedNearCacheTest().storageType(StorageType.OBJECT), new InvalidatedNearCacheTest().storageType(StorageType.BINARY), new InvalidatedNearCacheTest().storageType(StorageType.OFF_HEAP)};
    }

    protected String parameters() {
        return "[storageType-" + this.storageType + "]";
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder cb = HotRodTestingUtil.hotRodCacheConfiguration();
        cb.memory().storageType(this.storageType);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)cb);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createAssertClient();
        return this.assertClient.manager;
    }

    private <K, V> AssertsNearCache<K, V> createAssertClient() {
        ConfigurationBuilder builder = this.clientConfiguration();
        return AssertsNearCache.create(this.cache(), builder);
    }

    private ConfigurationBuilder clientConfiguration() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.nearCache().mode(this.getNearCacheMode()).maxEntries(-1);
        return builder;
    }

    private NearCacheMode getNearCacheMode() {
        return NearCacheMode.INVALIDATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNearCacheAfterConnect() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder(this.hotrodServer);
        builder.nearCache().mode(this.getNearCacheMode()).maxEntries(-1);
        RemoteCacheManager manager = new RemoteCacheManager(builder.build());
        try {
            RemoteCache cache = manager.getCache();
            cache.put((Object)1, (Object)"one");
            cache.put((Object)2, (Object)"two");
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(manager);
        }
        AssertsNearCache<Integer, String> newAssertClient = AssertsNearCache.create(this.cache(), builder);
        try {
            AssertJUnit.assertEquals((int)2, (int)newAssertClient.remote.size());
            newAssertClient.expectNoNearEvents();
            newAssertClient.get(1, "one").expectNearGetValue(1, null).expectNearPutIfAbsent(1, "one");
            newAssertClient.get(2, "two").expectNearGetValue(2, null).expectNearPutIfAbsent(2, "two");
            newAssertClient.remove(1).expectNearRemove(1, this.assertClient);
            newAssertClient.remove(2).expectNearRemove(2, this.assertClient);
        }
        finally {
            newAssertClient.stop();
        }
        this.assertClient.expectNoNearEvents();
    }

    public void testGetNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.get(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.get(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, null).expectNearGetNull(1);
    }

    public void testGetAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getAsync(1, null).expectNearGetNull(1);
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.getAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getAsync(1, "v1").expectNearGetValue(1, "v1");
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getAsync(1, null).expectNearGetNull(1);
    }

    public void testGetWithMetadataNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getWithMetadata(1, null).expectNearGetNull(1);
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.getWithMetadata(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getWithMetadata(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadata(1, null).expectNearGetNull(1);
    }

    public void testGetWithMetadataAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.getWithMetadataAsync(1, null).expectNearGetNull(1);
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.getWithMetadataAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
        this.assertClient.getWithMetadataAsync(1, "v1").expectNearGetValueVersion(1, "v1");
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getWithMetadataAsync(1, null).expectNearGetNull(1);
    }

    public void testUpdateNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.put(1, "v2").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.get(1, "v2").expectNearGetNull(1).expectNearPutIfAbsent(1, "v2");
        this.assertClient.get(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.put(1, "v3").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.remove(1).expectNearRemove(1, new AssertsNearCache[0]);
    }

    public void testUpdateAsyncNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1);
        this.assertClient.putAsync(1, "v2").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.getAsync(1, "v2").expectNearGetNull(1).expectNearPutIfAbsent(1, "v2");
        this.assertClient.getAsync(1, "v2").expectNearGetValue(1, "v2");
        this.assertClient.putAsync(1, "v3").expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.removeAsync(1).expectNearRemove(1, new AssertsNearCache[0]);
        this.assertClient.putAsync(1, "v4", 3L, TimeUnit.SECONDS).expectNearPreemptiveRemove(1);
        this.assertClient.putAsync(1, "v5", 3L, TimeUnit.SECONDS, 3L, TimeUnit.SECONDS).expectNearRemove(1, new AssertsNearCache[0]);
    }

    public void testGetUpdatesNearCache() {
        this.assertClient.expectNoNearEvents();
        this.assertClient.put(1, "v1").expectNearPreemptiveRemove(1);
        final AssertsNearCache newAsserts = this.createAssertClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                newAsserts.get(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
            }
        });
    }

    public void testGetAsyncUpdatesNearCache() throws ExecutionException, InterruptedException {
        this.assertClient.expectNoNearEvents();
        this.assertClient.putAsync(1, "v1").expectNearPreemptiveRemove(1);
        final AssertsNearCache newAsserts = this.createAssertClient();
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(newAsserts.manager){

            @Override
            public void call() {
                newAsserts.expectNoNearEvents();
                try {
                    newAsserts.getAsync(1, "v1").expectNearGetNull(1).expectNearPutIfAbsent(1, "v1");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp=".*When enabling near caching, number of max entries must be configured.*")
    public void testConfigurationWithoutMaxEntries() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder(this.hotrodServer);
        builder.nearCache().mode(this.getNearCacheMode());
        new RemoteCacheManager(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNearCacheNamePattern() {
        this.cacheManager.defineConfiguration("nearcache", new org.infinispan.configuration.cache.ConfigurationBuilder().build());
        ConfigurationBuilder builder = this.clientConfiguration();
        builder.nearCache().cacheNamePattern("near.*");
        RemoteCacheManager manager = new RemoteCacheManager(builder.build());
        try {
            RemoteCache nearcache = manager.getCache("nearcache");
            AssertJUnit.assertTrue((boolean)(nearcache instanceof InvalidatedNearRemoteCache));
            RemoteCache cache = manager.getCache();
            AssertJUnit.assertFalse((boolean)(cache instanceof InvalidatedNearRemoteCache));
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNearCachePerCache() {
        this.cacheManager.defineConfiguration("closecache", new org.infinispan.configuration.cache.ConfigurationBuilder().build());
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.remoteCache("closecache").nearCacheMode(NearCacheMode.INVALIDATED);
        RemoteCacheManager manager = new RemoteCacheManager(builder.build());
        try {
            RemoteCache nearcache = manager.getCache("closecache");
            AssertJUnit.assertTrue((boolean)(nearcache instanceof InvalidatedNearRemoteCache));
            RemoteCache cache = manager.getCache();
            AssertJUnit.assertFalse((boolean)(cache instanceof InvalidatedNearRemoteCache));
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(manager);
        }
    }
}

