/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.HotRodQueryTest", groups={"functional", "smoke"})
public class HotRodQueryTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "userCache";
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Integer, User> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.jmx().enabled(true).domain(((Object)((Object)this)).getClass().getSimpleName()).mBeanServerLookup(this.mBeanServerLookup);
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        gcb.serialization().addContextInitializer((SerializationContextInitializer)TestDomainSCI.INSTANCE);
        this.configure(gcb);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.getConfigurationBuilder();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, builder.build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue()).addContextInitializer((SerializationContextInitializer)TestDomainSCI.INSTANCE);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(TEST_CACHE_NAME);
        return this.cacheManager;
    }

    protected void configure(GlobalConfigurationBuilder builder) {
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAccountIds(Collections.singleton(12));
        AddressPB address1 = new AddressPB();
        address1.setStreet("Dark Alley");
        address1.setPostCode("1234");
        user1.setAddresses(Collections.singletonList(address1));
        this.remoteCache.put((Object)1, (Object)user1);
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Adrian");
        user2.setSurname("Nistor");
        user2.setGender(User.Gender.MALE);
        AddressPB address2 = new AddressPB();
        address2.setStreet("Old Street");
        address2.setPostCode("XYZ");
        user2.setAddresses(Collections.singletonList(address2));
        this.remoteCache.put((Object)2, (Object)user2);
    }

    protected void clearContent() {
    }

    public void testAttributeQuery() {
        User fromCache = (User)this.remoteCache.get((Object)1);
        AssertJUnit.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("name").eq((Object)"Tom").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    public void testEmbeddedAttributeQuery() {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("addresses.postCode").eq((Object)"1234").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028503: Property addresses can not be selected from type sample_bank_account.User since it is an embedded entity.")
    public void testInvalidEmbeddedAttributeQuery() {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query q = qf.from(UserPB.class).select(new String[]{"addresses"}).build();
        q.list();
    }

    public void testProjections() {
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).select(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        AssertJUnit.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private void assertUser1(User user) {
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((int)1, (int)user.getId());
        AssertJUnit.assertEquals((String)"Tom", (String)user.getName());
        AssertJUnit.assertEquals((String)"Cat", (String)user.getSurname());
        AssertJUnit.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        AssertJUnit.assertNotNull((Object)user.getAccountIds());
        AssertJUnit.assertEquals((int)1, (int)user.getAccountIds().size());
        AssertJUnit.assertTrue((boolean)user.getAccountIds().contains(12));
        AssertJUnit.assertNotNull((Object)user.getAddresses());
        AssertJUnit.assertEquals((int)1, (int)user.getAddresses().size());
        AssertJUnit.assertEquals((String)"Dark Alley", (String)((Address)user.getAddresses().get(0)).getStreet());
        AssertJUnit.assertEquals((String)"1234", (String)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

