/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Indexer;
import org.infinispan.query.dsl.Query;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.ReindexCacheTest", groups={"functional"})
public class ReindexCacheTest
extends SingleHotRodServerTest {
    private static final String USER_CACHE = "users";
    private static final int NUM_ENTRIES = 50;
    private StorageType storageType;

    @Factory
    public Object[] factory() {
        return new Object[]{new ReindexCacheTest().storageType(StorageType.OBJECT), new ReindexCacheTest().storageType(StorageType.OFF_HEAP)};
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createServerModeCacheManager((SerializationContextInitializer)this.contextInitializer(), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(USER_CACHE, HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.buildIndexedConfig()).build());
        return this.cacheManager;
    }

    protected String parameters() {
        return "storageType-" + this.storageType;
    }

    private ReindexCacheTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public ConfigurationBuilder buildIndexedConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)new ConfigurationBuilder());
        builder.memory().storageType(this.storageType).indexing().enable().addProperty("default.directory_provider", "local-heap");
        return builder;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @Test
    public void testMassIndexing() {
        RemoteCache userCache = this.remoteCacheManager.getCache(USER_CACHE);
        this.getUsersPB().forEach(u -> userCache.put((Object)u.getId(), u));
        Assert.assertEquals((int)this.query(userCache), (int)50);
        this.wipeIndexes();
        this.assertIndexEmpty();
        this.reindex();
        Assert.assertEquals((int)this.query(userCache), (int)50);
    }

    private void wipeIndexes() {
        Cache cache = this.cacheManager.getCache(USER_CACHE);
        Indexer indexer = org.infinispan.query.Search.getIndexer((Cache)cache);
        CompletionStages.join((CompletionStage)indexer.remove());
    }

    private void assertIndexEmpty() {
        Assert.assertEquals((int)this.query(this.remoteCacheManager.getCache(USER_CACHE)), (int)0);
    }

    private void reindex() {
        Cache cache = this.cacheManager.getCache(USER_CACHE);
        Indexer indexer = org.infinispan.query.Search.getIndexer((Cache)cache);
        CompletionStages.join((CompletionStage)indexer.run());
    }

    private int query(RemoteCache<?, ?> cache) {
        Query q = Search.getQueryFactory(cache).from(UserPB.class).build();
        return q.list().size();
    }

    private List<UserPB> getUsersPB() {
        return IntStream.range(0, 50).boxed().map(i -> {
            UserPB userPB = new UserPB();
            userPB.setId((int)i);
            userPB.setName("name" + i);
            userPB.setSurname("surname" + i);
            return userPB;
        }).collect(Collectors.toList());
    }
}

