/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.NotIndexedSCI;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.query.remote.impl.ProgrammaticSearchMappingProviderImpl;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDisableIndexingTest")
public class RemoteQueryDisableIndexingTest
extends AbstractQueryDslTest {
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    @BeforeClass
    protected void populateCache() {
        this.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected int getNodesCount() {
        return 1;
    }

    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().clusteredDefault();
        globalBuilder.serialization().addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE});
        this.createClusteredCaches(this.getNodesCount(), globalBuilder, this.getConfigurationBuilder(), true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue()).addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE});
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().enable().addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testEmptyIndexIsPresent() {
        SearchIntegrator searchIntegrator = (SearchIntegrator)TestingUtil.extractComponent(this.cache, SearchIntegrator.class);
        AssertJUnit.assertTrue((boolean)searchIntegrator.getIndexBindings().containsKey(ProtobufValueWrapper.INDEXING_TYPE));
        String indexName = ProgrammaticSearchMappingProviderImpl.getIndexName((String)this.cache.getName());
        AssertJUnit.assertNotNull((Object)searchIntegrator.getIndexManager(indexName));
        AssertJUnit.assertEquals((int)0, (int)searchIntegrator.getStatistics().getNumberOfIndexedEntities(ProtobufValueWrapper.class.getName()));
    }

    public void testEqNonIndexedType() {
        Query q = this.getQueryFactory().create("from sample_bank_account.NotIndexed where notIndexedField = 'testing 123'");
        List list = q.list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }
}

