/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.client.ProtobufMetadataManagerMBean;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryJmxTest", groups={"functional"})
public class RemoteQueryJmxTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "userCache";
    private static final String JMX_DOMAIN = RemoteQueryJmxTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private final MBeanServer mBeanServer = this.mBeanServerLookup.getMBeanServer();
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.jmx().enabled(true).domain(JMX_DOMAIN).mBeanServerLookup(this.mBeanServerLookup);
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, builder.build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue()).addContextInitializer((SerializationContextInitializer)TestDomainSCI.INSTANCE);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(TEST_CACHE_NAME);
        ProtobufMetadataManagerMBean protobufMetadataManagerMBean = JMX.newMBeanProxy(this.mBeanServer, this.getProtobufMetadataManagerObjectName(), ProtobufMetadataManagerMBean.class);
        String protofile = Util.getResourceAsString((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        protobufMetadataManagerMBean.registerProtofile("sample_bank_account/bank.proto", protofile);
        AssertJUnit.assertEquals((String)protofile, (String)protobufMetadataManagerMBean.getProtofile("sample_bank_account/bank.proto"));
        AssertJUnit.assertNull((Object)protobufMetadataManagerMBean.getFilesWithErrors());
        AssertJUnit.assertTrue((boolean)Arrays.asList(protobufMetadataManagerMBean.getProtofileNames()).contains("sample_bank_account/bank.proto"));
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testIndexAndQuery() throws Exception {
        ObjectName name = this.getQueryStatsObjectName(TEST_CACHE_NAME);
        AssertJUnit.assertTrue((boolean)this.mBeanServer.isRegistered(name));
        AssertJUnit.assertFalse((boolean)((Boolean)this.mBeanServer.getAttribute(name, "StatisticsEnabled")));
        this.mBeanServer.setAttribute(name, new Attribute("StatisticsEnabled", true));
        AssertJUnit.assertTrue((boolean)((Boolean)this.mBeanServer.getAttribute(name, "StatisticsEnabled")));
        this.remoteCache.put((Object)1, (Object)this.createUser(1));
        this.remoteCache.put((Object)2, (Object)this.createUser(2));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("addresses.postCode").eq((Object)"1231").build();
        List list = query.list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        AssertJUnit.assertEquals((String)"Tom1", (String)((User)list.get(0)).getName());
        AssertJUnit.assertEquals((Object)2, (Object)this.mBeanServer.invoke(name, "getNumberOfIndexedEntities", new Object[]{ProtobufValueWrapper.class.getName()}, new String[]{String.class.getName()}));
        Set classNames = (Set)this.mBeanServer.getAttribute(name, "IndexedClassNames");
        AssertJUnit.assertEquals((int)1, (int)classNames.size());
        AssertJUnit.assertTrue((String)"The set should contain the ProtobufValueWrapper class name.", (boolean)classNames.contains(ProtobufValueWrapper.class.getName()));
        AssertJUnit.assertTrue((String)"The query execution total time should be > 0.", ((Long)this.mBeanServer.getAttribute(name, "SearchQueryTotalTime") > 0L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((Object)1L, (Object)this.mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
    }

    private User createUser(int id) {
        UserPB user = new UserPB();
        user.setId(id);
        user.setName("Tom" + id);
        user.setSurname("Cat" + id);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        AddressPB address = new AddressPB();
        address.setStreet("Dark Alley");
        address.setPostCode("123" + id);
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private ObjectName getQueryStatsObjectName(String cacheName) throws MalformedObjectNameException {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().cacheManagerName();
        return new ObjectName(JMX_DOMAIN + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=Statistics");
    }

    private ObjectName getProtobufMetadataManagerObjectName() throws MalformedObjectNameException {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().cacheManagerName();
        return new ObjectName(JMX_DOMAIN + ":type=RemoteQuery,name=" + ObjectName.quote(cacheManagerName) + ",component=" + "ProtobufMetadataManager");
    }
}

