/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.ServerFailureRetrySingleOwnerTest")
public class ServerFailureRetrySingleOwnerTest
extends AbstractRetryTest {
    public ServerFailureRetrySingleOwnerTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    @Override
    protected ConfigurationBuilder getCacheConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ServerFailureRetrySingleOwnerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1).numSegments(1).consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory.Default(0, new int[0])).transaction().transactionMode(TransactionMode.TRANSACTIONAL).useSynchronization(true).locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        return builder;
    }

    public void testRetryReplaceWithVersion() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        MetadataValue versioned = this.remoteCache.getWithMetadata((Object)key);
        AssertJUnit.assertEquals((Object)1, (Object)versioned.getValue());
        this.withListener(listener, () -> this.lambda$testRetryReplaceWithVersion$0(listener, key, (VersionedValue)versioned));
    }

    public void testRetryRemoveWithVersion() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        MetadataValue versioned = this.remoteCache.getWithMetadata((Object)key);
        AssertJUnit.assertEquals((Object)1, (Object)versioned.getValue());
        this.withListener(listener, () -> this.lambda$testRetryRemoveWithVersion$1(listener, key, (VersionedValue)versioned));
    }

    public void testRetryRemove() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        this.withListener(listener, () -> {
            AssertJUnit.assertFalse((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.remove((Object)key));
            AssertJUnit.assertTrue((boolean)listener.errorInduced);
            AssertJUnit.assertNull((Object)this.remoteCache.get((Object)key));
        });
    }

    public void testRetryReplace() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        this.withListener(listener, () -> {
            AssertJUnit.assertFalse((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.replace((Object)key, (Object)2));
            AssertJUnit.assertTrue((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.get((Object)key));
        });
    }

    public void testRetryPutIfAbsent() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        this.withListener(listener, () -> {
            AssertJUnit.assertFalse((boolean)listener.errorInduced);
            AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
            AssertJUnit.assertTrue((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.get((Object)key));
        });
    }

    public void testRetryPutOnNonEmpty() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.put((Object)key, (Object)1));
        this.withListener(listener, () -> {
            AssertJUnit.assertFalse((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.put((Object)key, (Object)2));
            AssertJUnit.assertTrue((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.get((Object)key));
        });
    }

    public void testRetryPutOnEmpty() {
        ErrorInducingListener listener = new ErrorInducingListener();
        byte[] key = HotRodClientTestingUtil.getKeyForServer(this.hotRodServer1);
        this.withListener(listener, () -> {
            AssertJUnit.assertFalse((boolean)listener.errorInduced);
            AssertJUnit.assertNull((Object)this.remoteCache.put((Object)key, (Object)1));
            AssertJUnit.assertTrue((boolean)listener.errorInduced);
            AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.get((Object)key));
        });
    }

    private void withListener(Object listener, Runnable r) {
        this.hotRodServer1.getCacheManager().getCache().addListener(listener);
        try {
            r.run();
        }
        finally {
            this.hotRodServer1.getCacheManager().getCache().removeListener(listener);
        }
    }

    private /* synthetic */ void lambda$testRetryRemoveWithVersion$1(ErrorInducingListener listener, byte[] key, VersionedValue versioned) {
        AssertJUnit.assertFalse((boolean)listener.errorInduced);
        AssertJUnit.assertEquals((boolean)true, (boolean)this.remoteCache.removeWithVersion((Object)key, versioned.getVersion()));
        AssertJUnit.assertTrue((boolean)listener.errorInduced);
        AssertJUnit.assertNull((Object)this.remoteCache.get((Object)key));
    }

    private /* synthetic */ void lambda$testRetryReplaceWithVersion$0(ErrorInducingListener listener, byte[] key, VersionedValue versioned) {
        AssertJUnit.assertFalse((boolean)listener.errorInduced);
        AssertJUnit.assertEquals((boolean)true, (boolean)this.remoteCache.replaceWithVersion((Object)key, (Object)2, versioned.getVersion()));
        AssertJUnit.assertTrue((boolean)listener.errorInduced);
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.get((Object)key));
    }

    @Listener
    public static class ErrorInducingListener {
        boolean errorInduced;

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void handleEvent(CacheEntryEvent event) throws Exception {
            if (!event.isPre() && event.isOriginLocal()) {
                this.errorInduced = true;
                throw new SuspectException("Simulated suspicion");
            }
        }
    }
}

