/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"stress"})
public abstract class AbstractPutAllPerfTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected final long millisecondsToRun = TimeUnit.MINUTES.toMillis(1L);

    protected abstract int numberOfHotRodServers();

    protected abstract org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig();

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    protected void runTest(int size, String name) {
        long currentTime;
        long begin = System.currentTimeMillis();
        int iterations = 0;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Random random = new Random();
        while (this.millisecondsToRun + begin > (currentTime = System.currentTimeMillis())) {
            map.clear();
            for (int i = 0; i < size; ++i) {
                int value = random.nextInt(Integer.MAX_VALUE);
                map.put(value, value);
            }
            this.remoteCache.putAll(map);
            ++iterations;
        }
        long totalTime = currentTime - begin;
        System.out.println(name + " - Performed " + iterations + " in " + totalTime + " ms generating " + (long)iterations / (totalTime / 1000L) + " ops/sec");
    }

    public void test5Input() {
        this.runTest(5, "test5Input");
    }

    public void test500Input() {
        this.runTest(500, "test500Input");
    }

    public void test50000Input() {
        this.runTest(50000, "test50000Input");
    }
}

