/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.transcoding;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;

class JacksonMarshaller
extends AbstractMarshaller {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    JacksonMarshaller() {
    }

    protected ByteBuffer objectToBuffer(Object o, int estimatedSize) throws IOException {
        byte[] bytes = MAPPER.writeValueAsBytes(o);
        return ByteBufferImpl.create((byte[])bytes);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return MAPPER.readTree(buf);
    }

    public boolean isMarshallable(Object o) {
        return true;
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

